/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.Binder;
import oracle.jdbc.driver.CopiedByteBinder;
import oracle.jdbc.driver.CopiedCharBinder;
import oracle.jdbc.driver.CopiedNullBinder;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleBlobOutputStream;
import oracle.jdbc.driver.OracleClobWriter;
import oracle.jdbc.driver.OracleParameterMetaData;
import oracle.jdbc.driver.OraclePreparedStatementReadOnly;
import oracle.jdbc.driver.OracleResultSetImpl;
import oracle.jdbc.driver.OracleResultSetMetaData;
import oracle.jdbc.driver.OracleReturnResultSet;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.PlsqlIbtBindInfo;
import oracle.jdbc.driver.PlsqlIndexTableAccessor;
import oracle.jdbc.driver.ResultSetUtil;
import oracle.jdbc.driver.ScrollRsetStatement;
import oracle.jdbc.driver.T4CRowidAccessor;
import oracle.jdbc.internal.ObjectData;
import oracle.jdbc.internal.OracleStatement;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc.oracore.OracleTypeCOLLECTION;
import oracle.jdbc.oracore.OracleTypeNUMBER;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;
import oracle.sql.BFILE;
import oracle.sql.BINARY_DOUBLE;
import oracle.sql.BINARY_FLOAT;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.CharacterSet;
import oracle.sql.CustomDatum;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.INTERVALDS;
import oracle.sql.INTERVALYM;
import oracle.sql.NUMBER;
import oracle.sql.OPAQUE;
import oracle.sql.ORAData;
import oracle.sql.OpaqueDescriptor;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.ROWID;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;

abstract class OraclePreparedStatement
extends OracleStatement
implements oracle.jdbc.internal.OraclePreparedStatement,
ScrollRsetStatement {
    int numberOfBindRowsAllocated;
    static Binder theStaticVarnumCopyingBinder = OraclePreparedStatementReadOnly.theStaticVarnumCopyingBinder;
    static Binder theStaticVarnumNullBinder = OraclePreparedStatementReadOnly.theStaticVarnumNullBinder;
    Binder theVarnumNullBinder = theStaticVarnumNullBinder;
    static Binder theStaticBooleanBinder = OraclePreparedStatementReadOnly.theStaticBooleanBinder;
    Binder theBooleanBinder = theStaticBooleanBinder;
    static Binder theStaticByteBinder = OraclePreparedStatementReadOnly.theStaticByteBinder;
    Binder theByteBinder = theStaticByteBinder;
    static Binder theStaticShortBinder = OraclePreparedStatementReadOnly.theStaticShortBinder;
    Binder theShortBinder = theStaticShortBinder;
    static Binder theStaticIntBinder = OraclePreparedStatementReadOnly.theStaticIntBinder;
    Binder theIntBinder = theStaticIntBinder;
    static Binder theStaticLongBinder = OraclePreparedStatementReadOnly.theStaticLongBinder;
    Binder theLongBinder = theStaticLongBinder;
    static Binder theStaticFloatBinder = OraclePreparedStatementReadOnly.theStaticFloatBinder;
    Binder theFloatBinder = null;
    static Binder theStaticDoubleBinder = OraclePreparedStatementReadOnly.theStaticDoubleBinder;
    Binder theDoubleBinder = null;
    static Binder theStaticBigDecimalBinder = OraclePreparedStatementReadOnly.theStaticBigDecimalBinder;
    Binder theBigDecimalBinder = theStaticBigDecimalBinder;
    static Binder theStaticVarcharCopyingBinder = OraclePreparedStatementReadOnly.theStaticVarcharCopyingBinder;
    static Binder theStaticVarcharNullBinder = OraclePreparedStatementReadOnly.theStaticVarcharNullBinder;
    Binder theVarcharNullBinder = theStaticVarcharNullBinder;
    static Binder theStaticStringBinder = OraclePreparedStatementReadOnly.theStaticStringBinder;
    Binder theStringBinder = theStaticStringBinder;
    static Binder theStaticSetCHARCopyingBinder = OraclePreparedStatementReadOnly.theStaticSetCHARCopyingBinder;
    static Binder theStaticSetCHARBinder = OraclePreparedStatementReadOnly.theStaticSetCHARBinder;
    static Binder theStaticLittleEndianSetCHARBinder = OraclePreparedStatementReadOnly.theStaticLittleEndianSetCHARBinder;
    static Binder theStaticSetCHARNullBinder = OraclePreparedStatementReadOnly.theStaticSetCHARNullBinder;
    Binder theSetCHARBinder;
    Binder theSetCHARNullBinder = theStaticSetCHARNullBinder;
    static Binder theStaticFixedCHARCopyingBinder = OraclePreparedStatementReadOnly.theStaticFixedCHARCopyingBinder;
    static Binder theStaticFixedCHARBinder = OraclePreparedStatementReadOnly.theStaticFixedCHARBinder;
    static Binder theStaticFixedCHARNullBinder = OraclePreparedStatementReadOnly.theStaticFixedCHARNullBinder;
    Binder theFixedCHARBinder = theStaticFixedCHARBinder;
    Binder theFixedCHARNullBinder = theStaticFixedCHARNullBinder;
    static Binder theStaticDateCopyingBinder = OraclePreparedStatementReadOnly.theStaticDateCopyingBinder;
    static Binder theStaticDateBinder = OraclePreparedStatementReadOnly.theStaticDateBinder;
    static Binder theStaticDateNullBinder = OraclePreparedStatementReadOnly.theStaticDateNullBinder;
    Binder theDateBinder = theStaticDateBinder;
    Binder theDateNullBinder = theStaticDateNullBinder;
    static Binder theStaticTimeCopyingBinder = OraclePreparedStatementReadOnly.theStaticTimeCopyingBinder;
    static Binder theStaticTimeBinder = OraclePreparedStatementReadOnly.theStaticTimeBinder;
    Binder theTimeBinder = theStaticTimeBinder;
    static Binder theStaticTimestampCopyingBinder = OraclePreparedStatementReadOnly.theStaticTimestampCopyingBinder;
    static Binder theStaticTimestampBinder = OraclePreparedStatementReadOnly.theStaticTimestampBinder;
    static Binder theStaticTimestampNullBinder = OraclePreparedStatementReadOnly.theStaticTimestampNullBinder;
    Binder theTimestampBinder = theStaticTimestampBinder;
    Binder theTimestampNullBinder = theStaticTimestampNullBinder;
    static Binder theStaticOracleNumberBinder = OraclePreparedStatementReadOnly.theStaticOracleNumberBinder;
    Binder theOracleNumberBinder = theStaticOracleNumberBinder;
    static Binder theStaticOracleDateBinder = OraclePreparedStatementReadOnly.theStaticOracleDateBinder;
    Binder theOracleDateBinder = theStaticOracleDateBinder;
    static Binder theStaticOracleTimestampBinder = OraclePreparedStatementReadOnly.theStaticOracleTimestampBinder;
    Binder theOracleTimestampBinder = theStaticOracleTimestampBinder;
    static Binder theStaticTSTZCopyingBinder = OraclePreparedStatementReadOnly.theStaticTSTZCopyingBinder;
    static Binder theStaticTSTZBinder = OraclePreparedStatementReadOnly.theStaticTSTZBinder;
    static Binder theStaticTSTZNullBinder = OraclePreparedStatementReadOnly.theStaticTSTZNullBinder;
    Binder theTSTZBinder = theStaticTSTZBinder;
    Binder theTSTZNullBinder = theStaticTSTZNullBinder;
    static Binder theStaticTSLTZCopyingBinder = OraclePreparedStatementReadOnly.theStaticTSLTZCopyingBinder;
    static Binder theStaticTSLTZBinder = OraclePreparedStatementReadOnly.theStaticTSLTZBinder;
    static Binder theStaticTSLTZNullBinder = OraclePreparedStatementReadOnly.theStaticTSLTZNullBinder;
    Binder theTSLTZBinder = theStaticTSLTZBinder;
    Binder theTSLTZNullBinder = theStaticTSLTZNullBinder;
    static Binder theStaticRowidCopyingBinder = OraclePreparedStatementReadOnly.theStaticRowidCopyingBinder;
    static Binder theStaticRowidBinder = OraclePreparedStatementReadOnly.theStaticRowidBinder;
    static Binder theStaticLittleEndianRowidBinder = OraclePreparedStatementReadOnly.theStaticLittleEndianRowidBinder;
    static Binder theStaticRowidNullBinder = OraclePreparedStatementReadOnly.theStaticRowidNullBinder;
    static Binder theStaticURowidNullBinder = OraclePreparedStatementReadOnly.theStaticURowidNullBinder;
    Binder theRowidBinder;
    Binder theRowidNullBinder = theStaticRowidNullBinder;
    Binder theURowidBinder;
    Binder theURowidNullBinder = theStaticURowidNullBinder;
    static Binder theStaticIntervalDSCopyingBinder = OraclePreparedStatementReadOnly.theStaticIntervalDSCopyingBinder;
    static Binder theStaticIntervalDSBinder = OraclePreparedStatementReadOnly.theStaticIntervalDSBinder;
    static Binder theStaticIntervalDSNullBinder = OraclePreparedStatementReadOnly.theStaticIntervalDSNullBinder;
    Binder theIntervalDSBinder = theStaticIntervalDSBinder;
    Binder theIntervalDSNullBinder = theStaticIntervalDSNullBinder;
    static Binder theStaticIntervalYMCopyingBinder = OraclePreparedStatementReadOnly.theStaticIntervalYMCopyingBinder;
    static Binder theStaticIntervalYMBinder = OraclePreparedStatementReadOnly.theStaticIntervalYMBinder;
    static Binder theStaticIntervalYMNullBinder = OraclePreparedStatementReadOnly.theStaticIntervalYMNullBinder;
    Binder theIntervalYMBinder = theStaticIntervalYMBinder;
    Binder theIntervalYMNullBinder = theStaticIntervalYMNullBinder;
    static Binder theStaticBfileCopyingBinder = OraclePreparedStatementReadOnly.theStaticBfileCopyingBinder;
    static Binder theStaticBfileBinder = OraclePreparedStatementReadOnly.theStaticBfileBinder;
    static Binder theStaticBfileNullBinder = OraclePreparedStatementReadOnly.theStaticBfileNullBinder;
    Binder theBfileBinder = theStaticBfileBinder;
    Binder theBfileNullBinder = theStaticBfileNullBinder;
    static Binder theStaticBlobCopyingBinder = OraclePreparedStatementReadOnly.theStaticBlobCopyingBinder;
    static Binder theStaticBlobBinder = OraclePreparedStatementReadOnly.theStaticBlobBinder;
    static Binder theStaticBlobNullBinder = OraclePreparedStatementReadOnly.theStaticBlobNullBinder;
    Binder theBlobBinder = theStaticBlobBinder;
    Binder theBlobNullBinder = theStaticBlobNullBinder;
    static Binder theStaticClobCopyingBinder = OraclePreparedStatementReadOnly.theStaticClobCopyingBinder;
    static Binder theStaticClobBinder = OraclePreparedStatementReadOnly.theStaticClobBinder;
    static Binder theStaticClobNullBinder = OraclePreparedStatementReadOnly.theStaticClobNullBinder;
    Binder theClobBinder = theStaticClobBinder;
    Binder theClobNullBinder = theStaticClobNullBinder;
    static Binder theStaticRawCopyingBinder = OraclePreparedStatementReadOnly.theStaticRawCopyingBinder;
    static Binder theStaticRawBinder = OraclePreparedStatementReadOnly.theStaticRawBinder;
    static Binder theStaticRawNullBinder = OraclePreparedStatementReadOnly.theStaticRawNullBinder;
    Binder theRawBinder = theStaticRawBinder;
    Binder theRawNullBinder = theStaticRawNullBinder;
    static Binder theStaticPlsqlRawCopyingBinder = OraclePreparedStatementReadOnly.theStaticPlsqlRawCopyingBinder;
    static Binder theStaticPlsqlRawBinder = OraclePreparedStatementReadOnly.theStaticPlsqlRawBinder;
    Binder thePlsqlRawBinder = theStaticPlsqlRawBinder;
    static Binder theStaticBinaryFloatCopyingBinder = OraclePreparedStatementReadOnly.theStaticBinaryFloatCopyingBinder;
    static Binder theStaticBinaryFloatBinder = OraclePreparedStatementReadOnly.theStaticBinaryFloatBinder;
    static Binder theStaticBinaryFloatNullBinder = OraclePreparedStatementReadOnly.theStaticBinaryFloatNullBinder;
    Binder theBinaryFloatBinder = theStaticBinaryFloatBinder;
    Binder theBinaryFloatNullBinder = theStaticBinaryFloatNullBinder;
    static Binder theStaticBINARY_FLOATCopyingBinder = OraclePreparedStatementReadOnly.theStaticBINARY_FLOATCopyingBinder;
    static Binder theStaticBINARY_FLOATBinder = OraclePreparedStatementReadOnly.theStaticBINARY_FLOATBinder;
    static Binder theStaticBINARY_FLOATNullBinder = OraclePreparedStatementReadOnly.theStaticBINARY_FLOATNullBinder;
    Binder theBINARY_FLOATBinder = theStaticBINARY_FLOATBinder;
    Binder theBINARY_FLOATNullBinder = theStaticBINARY_FLOATNullBinder;
    static Binder theStaticBinaryDoubleCopyingBinder = OraclePreparedStatementReadOnly.theStaticBinaryDoubleCopyingBinder;
    static Binder theStaticBinaryDoubleBinder = OraclePreparedStatementReadOnly.theStaticBinaryDoubleBinder;
    static Binder theStaticBinaryDoubleNullBinder = OraclePreparedStatementReadOnly.theStaticBinaryDoubleNullBinder;
    Binder theBinaryDoubleBinder = theStaticBinaryDoubleBinder;
    Binder theBinaryDoubleNullBinder = theStaticBinaryDoubleNullBinder;
    static Binder theStaticBINARY_DOUBLECopyingBinder = OraclePreparedStatementReadOnly.theStaticBINARY_DOUBLECopyingBinder;
    static Binder theStaticBINARY_DOUBLEBinder = OraclePreparedStatementReadOnly.theStaticBINARY_DOUBLEBinder;
    static Binder theStaticBINARY_DOUBLENullBinder = OraclePreparedStatementReadOnly.theStaticBINARY_DOUBLENullBinder;
    Binder theBINARY_DOUBLEBinder = theStaticBINARY_DOUBLEBinder;
    Binder theBINARY_DOUBLENullBinder = theStaticBINARY_DOUBLENullBinder;
    static Binder theStaticLongStreamBinder = OraclePreparedStatementReadOnly.theStaticLongStreamBinder;
    Binder theLongStreamBinder = theStaticLongStreamBinder;
    static Binder theStaticLongStreamForStringBinder = OraclePreparedStatementReadOnly.theStaticLongStreamForStringBinder;
    Binder theLongStreamForStringBinder = theStaticLongStreamForStringBinder;
    static Binder theStaticLongStreamForStringCopyingBinder = OraclePreparedStatementReadOnly.theStaticLongStreamForStringCopyingBinder;
    static Binder theStaticLongRawStreamBinder = OraclePreparedStatementReadOnly.theStaticLongRawStreamBinder;
    Binder theLongRawStreamBinder = theStaticLongRawStreamBinder;
    static Binder theStaticLongRawStreamForBytesBinder = OraclePreparedStatementReadOnly.theStaticLongRawStreamForBytesBinder;
    Binder theLongRawStreamForBytesBinder = theStaticLongRawStreamForBytesBinder;
    static Binder theStaticLongRawStreamForBytesCopyingBinder = OraclePreparedStatementReadOnly.theStaticLongRawStreamForBytesCopyingBinder;
    static Binder theStaticNamedTypeCopyingBinder = OraclePreparedStatementReadOnly.theStaticNamedTypeCopyingBinder;
    static Binder theStaticNamedTypeBinder = OraclePreparedStatementReadOnly.theStaticNamedTypeBinder;
    static Binder theStaticNamedTypeNullBinder = OraclePreparedStatementReadOnly.theStaticNamedTypeNullBinder;
    Binder theNamedTypeBinder = theStaticNamedTypeBinder;
    Binder theNamedTypeNullBinder = theStaticNamedTypeNullBinder;
    static Binder theStaticRefTypeCopyingBinder = OraclePreparedStatementReadOnly.theStaticRefTypeCopyingBinder;
    static Binder theStaticRefTypeBinder = OraclePreparedStatementReadOnly.theStaticRefTypeBinder;
    static Binder theStaticRefTypeNullBinder = OraclePreparedStatementReadOnly.theStaticRefTypeNullBinder;
    Binder theRefTypeBinder = theStaticRefTypeBinder;
    Binder theRefTypeNullBinder = theStaticRefTypeNullBinder;
    static Binder theStaticPlsqlIbtCopyingBinder = OraclePreparedStatementReadOnly.theStaticPlsqlIbtCopyingBinder;
    static Binder theStaticPlsqlIbtBinder = OraclePreparedStatementReadOnly.theStaticPlsqlIbtBinder;
    static Binder theStaticPlsqlIbtNullBinder = OraclePreparedStatementReadOnly.theStaticPlsqlIbtNullBinder;
    Binder thePlsqlIbtBinder = theStaticPlsqlIbtBinder;
    Binder thePlsqlNullBinder = theStaticPlsqlIbtNullBinder;
    static Binder theStaticOutBinder = OraclePreparedStatementReadOnly.theStaticOutBinder;
    Binder theOutBinder = theStaticOutBinder;
    static Binder theStaticReturnParamBinder = OraclePreparedStatementReadOnly.theStaticReturnParamBinder;
    Binder theReturnParamBinder = theStaticReturnParamBinder;
    static Binder theStaticT4CRowidBinder = OraclePreparedStatementReadOnly.theStaticT4CRowidBinder;
    static Binder theStaticT4CURowidBinder = OraclePreparedStatementReadOnly.theStaticT4CURowidBinder;
    static Binder theStaticT4CRowidNullBinder = OraclePreparedStatementReadOnly.theStaticT4CRowidNullBinder;
    static Binder theStaticT4CURowidNullBinder = OraclePreparedStatementReadOnly.theStaticT4CURowidNullBinder;
    private static final TimeZone UTC_TIME_ZONE = TimeZone.getTimeZone("UTC");
    private static final Calendar UTC_US_CALENDAR = Calendar.getInstance(UTC_TIME_ZONE, Locale.US);
    protected Calendar cachedUTCUSCalendar = (Calendar)UTC_US_CALENDAR.clone();
    public static final int TypeBinder_BYTELEN = 24;
    char[] digits = new char[20];
    Binder[][] binders;
    int[][] parameterInt;
    long[][] parameterLong;
    float[][] parameterFloat;
    double[][] parameterDouble;
    BigDecimal[][] parameterBigDecimal;
    String[][] parameterString;
    Date[][] parameterDate;
    Time[][] parameterTime;
    Timestamp[][] parameterTimestamp;
    byte[][][] parameterDatum;
    OracleTypeADT[][] parameterOtype;
    CLOB[] lastBoundClobs;
    BLOB[] lastBoundBlobs;
    PlsqlIbtBindInfo[][] parameterPlsqlIbt;
    Binder[] currentRowBinders;
    int[] currentRowCharLens;
    Accessor[] currentRowBindAccessors;
    short[] currentRowFormOfUse;
    boolean currentRowNeedToPrepareBinds = true;
    int[] currentBatchCharLens;
    Accessor[] currentBatchBindAccessors;
    short[] currentBatchFormOfUse;
    boolean currentBatchNeedToPrepareBinds;
    PushedBatch pushedBatches;
    PushedBatch pushedBatchesTail;
    int cachedBindByteSize = 0;
    int cachedBindCharSize = 0;
    int cachedBindIndicatorSize = 0;
    int totalBindByteLength;
    int totalBindCharLength;
    int totalBindIndicatorLength;
    static final int BIND_METADATA_NUMBER_OF_BIND_POSITIONS_OFFSET = 0;
    static final int BIND_METADATA_BIND_BUFFER_CAPACITY_OFFSET_HI = 1;
    static final int BIND_METADATA_BIND_BUFFER_CAPACITY_OFFSET_LO = 2;
    static final int BIND_METADATA_NUMBER_OF_BOUND_ROWS_OFFSET_HI = 3;
    static final int BIND_METADATA_NUMBER_OF_BOUND_ROWS_OFFSET_LO = 4;
    static final int BIND_METADATA_PER_POSITION_DATA_OFFSET = 5;
    static final int BIND_METADATA_TYPE_OFFSET = 0;
    static final int BIND_METADATA_BYTE_PITCH_OFFSET = 1;
    static final int BIND_METADATA_CHAR_PITCH_OFFSET = 2;
    static final int BIND_METADATA_VALUE_DATA_OFFSET_HI = 3;
    static final int BIND_METADATA_VALUE_DATA_OFFSET_LO = 4;
    static final int BIND_METADATA_NULL_INDICATORS_OFFSET_HI = 5;
    static final int BIND_METADATA_NULL_INDICATORS_OFFSET_LO = 6;
    static final int BIND_METADATA_VALUE_LENGTHS_OFFSET_HI = 7;
    static final int BIND_METADATA_VALUE_LENGTHS_OFFSET_LO = 8;
    static final int BIND_METADATA_FORM_OF_USE_OFFSET = 9;
    static final int BIND_METADATA_PER_POSITION_SIZE = 10;
    static final int SETLOB_NO_LENGTH = -1;
    int bindBufferCapacity;
    int numberOfBoundRows;
    int indicatorsOffset;
    int valueLengthsOffset;
    boolean preparedAllBinds;
    boolean preparedCharBinds;
    Binder[] lastBinders;
    byte[] lastBoundBytes;
    int lastBoundByteOffset;
    char[] lastBoundChars;
    int lastBoundCharOffset;
    int[] lastBoundByteOffsets;
    int[] lastBoundCharOffsets;
    int[] lastBoundByteLens;
    int[] lastBoundCharLens;
    short[] lastBoundInds;
    short[] lastBoundLens;
    boolean lastBoundNeeded = false;
    byte[][] lastBoundTypeBytes;
    OracleTypeADT[] lastBoundTypeOtypes;
    InputStream[] lastBoundStream;
    private static final int STREAM_MAX_BYTES_SQL = Integer.MAX_VALUE;
    int maxRawBytesSql;
    int maxRawBytesPlsql;
    int maxVcsCharsSql;
    int maxVcsNCharsSql;
    int maxVcsBytesPlsql;
    private int maxCharSize = 0;
    private int maxNCharSize = 0;
    private int charMaxCharsSql = 0;
    private int charMaxNCharsSql = 0;
    private int maxVcsCharsPlsql = 0;
    private int maxVcsNCharsPlsql = 0;
    int maxIbtVarcharElementLength = 0;
    private int maxStreamCharsSql = 0;
    private int maxStreamNCharsSql = 0;
    protected boolean isServerCharSetFixedWidth = false;
    private boolean isServerNCharSetFixedWidth = false;
    int minVcsBindSize;
    int prematureBatchCount;
    boolean checkBindTypes = true;
    boolean scrollRsetTypeSolved;
    int SetBigStringTryClob = 0;
    static final int BSTYLE_UNKNOWN = 0;
    static final int BSTYLE_ORACLE = 1;
    static final int BSTYLE_JDBC = 2;
    int m_batchStyle = 0;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Mon_Aug_29_23:34:29_PDT_2011";
    public static final boolean TRACE = false;

    OraclePreparedStatement(PhysicalConnection physicalConnection, String string, int n2, int n3) throws SQLException {
        this(physicalConnection, string, n2, n3, 1003, 1007);
        this.cacheState = 1;
    }

    OraclePreparedStatement(PhysicalConnection physicalConnection, String string, int n2, int n3, int n4, int n5) throws SQLException {
        super(physicalConnection, n2, n3, n4, n5);
        this.cacheState = 1;
        if (n2 > 1) {
            this.setOracleBatchStyle();
        }
        this.theSetCHARBinder = physicalConnection.useLittleEndianSetCHARBinder() ? theStaticLittleEndianSetCHARBinder : theStaticSetCHARBinder;
        this.theRowidBinder = physicalConnection.useLittleEndianSetCHARBinder() ? theStaticLittleEndianRowidBinder : theStaticRowidBinder;
        this.theURowidBinder = this.theRowidBinder;
        this.statementType = 1;
        this.currentRow = -1;
        this.needToParse = true;
        this.processEscapes = physicalConnection.processEscapes;
        this.sqlObject.initialize(string);
        this.sqlKind = this.sqlObject.getSqlKind();
        this.clearParameters = true;
        this.scrollRsetTypeSolved = false;
        this.prematureBatchCount = 0;
        this.initializeBinds();
        this.minVcsBindSize = physicalConnection.minVcsBindSize;
        this.maxRawBytesSql = physicalConnection.maxRawBytesSql;
        this.maxRawBytesPlsql = physicalConnection.maxRawBytesPlsql;
        this.maxVcsCharsSql = physicalConnection.maxVcsCharsSql;
        this.maxVcsNCharsSql = physicalConnection.maxVcsNCharsSql;
        this.maxVcsBytesPlsql = physicalConnection.maxVcsBytesPlsql;
        this.maxIbtVarcharElementLength = physicalConnection.maxIbtVarcharElementLength;
        this.maxCharSize = this.connection.conversion.sMaxCharSize;
        this.maxNCharSize = this.connection.conversion.maxNCharSize;
        this.maxVcsCharsPlsql = this.maxVcsBytesPlsql / this.maxCharSize;
        this.maxVcsNCharsPlsql = this.maxVcsBytesPlsql / this.maxNCharSize;
        this.maxStreamCharsSql = Integer.MAX_VALUE / this.maxCharSize;
        this.maxStreamNCharsSql = this.maxRawBytesSql / this.maxNCharSize;
        this.isServerCharSetFixedWidth = this.connection.conversion.isServerCharSetFixedWidth;
        this.isServerNCharSetFixedWidth = this.connection.conversion.isServerNCharSetFixedWidth;
    }

    void allocBinds(int n2) throws SQLException {
        int n3;
        boolean bl = n2 > this.numberOfBindRowsAllocated;
        this.initializeIndicatorSubRange();
        int n4 = this.bindIndicatorSubRange + 5 + this.numberOfBindPositions * 10;
        int n5 = n2 * this.numberOfBindPositions;
        int n6 = n4 + 2 * n5;
        if (n6 > this.totalBindIndicatorLength) {
            short[] sArray = this.bindIndicators;
            n3 = this.bindIndicatorOffset;
            this.bindIndicatorOffset = 0;
            this.bindIndicators = new short[n6];
            this.totalBindIndicatorLength = n6;
            if (sArray != null && bl) {
                System.arraycopy(sArray, n3, this.bindIndicators, this.bindIndicatorOffset, n4);
            }
        }
        this.bindIndicatorSubRange += this.bindIndicatorOffset;
        this.bindIndicators[this.bindIndicatorSubRange + 0] = (short)this.numberOfBindPositions;
        this.indicatorsOffset = this.bindIndicatorOffset + n4;
        this.valueLengthsOffset = this.indicatorsOffset + n5;
        int n7 = this.indicatorsOffset;
        n3 = this.valueLengthsOffset;
        int n8 = this.bindIndicatorSubRange + 5;
        for (int i2 = 0; i2 < this.numberOfBindPositions; ++i2) {
            this.bindIndicators[n8 + 5] = (short)(n7 >> 16);
            this.bindIndicators[n8 + 6] = (short)(n7 & 0xFFFF);
            this.bindIndicators[n8 + 7] = (short)(n3 >> 16);
            this.bindIndicators[n8 + 8] = (short)(n3 & 0xFFFF);
            n7 += n2;
            n3 += n2;
            n8 += 10;
        }
    }

    void initializeBinds() throws SQLException {
        this.numberOfBindPositions = this.sqlObject.getParameterCount();
        this.numReturnParams = this.sqlObject.getReturnParameterCount();
        if (this.numberOfBindPositions == 0) {
            this.currentRowNeedToPrepareBinds = false;
            return;
        }
        this.numberOfBindRowsAllocated = this.batch;
        this.binders = new Binder[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
        this.currentRowBinders = this.binders[0];
        this.currentRowCharLens = new int[this.numberOfBindPositions];
        this.currentBatchCharLens = new int[this.numberOfBindPositions];
        this.currentRowFormOfUse = new short[this.numberOfBindPositions];
        this.currentBatchFormOfUse = new short[this.numberOfBindPositions];
        this.lastBoundClobs = new CLOB[this.numberOfBindPositions];
        this.lastBoundBlobs = new BLOB[this.numberOfBindPositions];
        int n2 = 1;
        if (this.connection.defaultnchar) {
            n2 = 2;
        }
        for (int i2 = 0; i2 < this.numberOfBindPositions; ++i2) {
            this.currentRowFormOfUse[i2] = n2;
            this.currentBatchFormOfUse[i2] = n2;
        }
        this.lastBinders = new Binder[this.numberOfBindPositions];
        this.lastBoundCharLens = new int[this.numberOfBindPositions];
        this.lastBoundByteOffsets = new int[this.numberOfBindPositions];
        this.lastBoundCharOffsets = new int[this.numberOfBindPositions];
        this.lastBoundByteLens = new int[this.numberOfBindPositions];
        this.lastBoundInds = new short[this.numberOfBindPositions];
        this.lastBoundLens = new short[this.numberOfBindPositions];
        this.lastBoundTypeBytes = new byte[this.numberOfBindPositions][];
        this.lastBoundTypeOtypes = new OracleTypeADT[this.numberOfBindPositions];
        this.allocBinds(this.numberOfBindRowsAllocated);
    }

    void growBinds(int n2) throws SQLException {
        Object object;
        int n3;
        Binder[][] binderArray = this.binders;
        this.binders = new Binder[n2][];
        if (binderArray != null) {
            System.arraycopy(binderArray, 0, this.binders, 0, this.numberOfBindRowsAllocated);
        }
        for (n3 = this.numberOfBindRowsAllocated; n3 < n2; ++n3) {
            this.binders[n3] = new Binder[this.numberOfBindPositions];
        }
        this.allocBinds(n2);
        if (this.parameterInt != null) {
            object = this.parameterInt;
            this.parameterInt = new int[n2][];
            System.arraycopy(object, 0, this.parameterInt, 0, this.numberOfBindRowsAllocated);
            for (n3 = this.numberOfBindRowsAllocated; n3 < n2; ++n3) {
                this.parameterInt[n3] = new int[this.numberOfBindPositions];
            }
        }
        if (this.parameterLong != null) {
            object = this.parameterLong;
            this.parameterLong = new long[n2][];
            System.arraycopy(object, 0, this.parameterLong, 0, this.numberOfBindRowsAllocated);
            for (n3 = this.numberOfBindRowsAllocated; n3 < n2; ++n3) {
                this.parameterLong[n3] = new long[this.numberOfBindPositions];
            }
        }
        if (this.parameterFloat != null) {
            object = this.parameterFloat;
            this.parameterFloat = new float[n2][];
            System.arraycopy(object, 0, this.parameterFloat, 0, this.numberOfBindRowsAllocated);
            for (n3 = this.numberOfBindRowsAllocated; n3 < n2; ++n3) {
                this.parameterFloat[n3] = new float[this.numberOfBindPositions];
            }
        }
        if (this.parameterDouble != null) {
            object = this.parameterDouble;
            this.parameterDouble = new double[n2][];
            System.arraycopy(object, 0, this.parameterDouble, 0, this.numberOfBindRowsAllocated);
            for (n3 = this.numberOfBindRowsAllocated; n3 < n2; ++n3) {
                this.parameterDouble[n3] = new double[this.numberOfBindPositions];
            }
        }
        if (this.parameterBigDecimal != null) {
            object = this.parameterBigDecimal;
            this.parameterBigDecimal = new BigDecimal[n2][];
            System.arraycopy(object, 0, this.parameterBigDecimal, 0, this.numberOfBindRowsAllocated);
            for (n3 = this.numberOfBindRowsAllocated; n3 < n2; ++n3) {
                this.parameterBigDecimal[n3] = new BigDecimal[this.numberOfBindPositions];
            }
        }
        if (this.parameterString != null) {
            object = this.parameterString;
            this.parameterString = new String[n2][];
            System.arraycopy(object, 0, this.parameterString, 0, this.numberOfBindRowsAllocated);
            for (n3 = this.numberOfBindRowsAllocated; n3 < n2; ++n3) {
                this.parameterString[n3] = new String[this.numberOfBindPositions];
            }
        }
        if (this.parameterDate != null) {
            object = this.parameterDate;
            this.parameterDate = new Date[n2][];
            System.arraycopy(object, 0, this.parameterDate, 0, this.numberOfBindRowsAllocated);
            for (n3 = this.numberOfBindRowsAllocated; n3 < n2; ++n3) {
                this.parameterDate[n3] = new Date[this.numberOfBindPositions];
            }
        }
        if (this.parameterTime != null) {
            object = this.parameterTime;
            this.parameterTime = new Time[n2][];
            System.arraycopy(object, 0, this.parameterTime, 0, this.numberOfBindRowsAllocated);
            for (n3 = this.numberOfBindRowsAllocated; n3 < n2; ++n3) {
                this.parameterTime[n3] = new Time[this.numberOfBindPositions];
            }
        }
        if (this.parameterTimestamp != null) {
            object = this.parameterTimestamp;
            this.parameterTimestamp = new Timestamp[n2][];
            System.arraycopy(object, 0, this.parameterTimestamp, 0, this.numberOfBindRowsAllocated);
            for (n3 = this.numberOfBindRowsAllocated; n3 < n2; ++n3) {
                this.parameterTimestamp[n3] = new Timestamp[this.numberOfBindPositions];
            }
        }
        if (this.parameterDatum != null) {
            object = this.parameterDatum;
            this.parameterDatum = new byte[n2][][];
            System.arraycopy(object, 0, this.parameterDatum, 0, this.numberOfBindRowsAllocated);
            for (n3 = this.numberOfBindRowsAllocated; n3 < n2; ++n3) {
                this.parameterDatum[n3] = new byte[this.numberOfBindPositions][];
            }
        }
        if (this.parameterOtype != null) {
            object = this.parameterOtype;
            this.parameterOtype = new OracleTypeADT[n2][];
            System.arraycopy(object, 0, this.parameterOtype, 0, this.numberOfBindRowsAllocated);
            for (n3 = this.numberOfBindRowsAllocated; n3 < n2; ++n3) {
                this.parameterOtype[n3] = new OracleTypeADT[this.numberOfBindPositions];
            }
        }
        if (this.parameterStream != null) {
            object = this.parameterStream;
            this.parameterStream = new InputStream[n2][];
            System.arraycopy(object, 0, this.parameterStream, 0, this.numberOfBindRowsAllocated);
            for (n3 = this.numberOfBindRowsAllocated; n3 < n2; ++n3) {
                this.parameterStream[n3] = new InputStream[this.numberOfBindPositions];
            }
        }
        if (this.userStream != null) {
            object = this.userStream;
            this.userStream = new Object[n2][];
            System.arraycopy(object, 0, this.userStream, 0, this.numberOfBindRowsAllocated);
            for (n3 = this.numberOfBindRowsAllocated; n3 < n2; ++n3) {
                this.userStream[n3] = new Object[this.numberOfBindPositions];
            }
        }
        if (this.parameterPlsqlIbt != null) {
            object = this.parameterPlsqlIbt;
            this.parameterPlsqlIbt = new PlsqlIbtBindInfo[n2][];
            System.arraycopy(object, 0, this.parameterPlsqlIbt, 0, this.numberOfBindRowsAllocated);
            for (n3 = this.numberOfBindRowsAllocated; n3 < n2; ++n3) {
                this.parameterPlsqlIbt[n3] = new PlsqlIbtBindInfo[this.numberOfBindPositions];
            }
        }
        this.numberOfBindRowsAllocated = n2;
        this.currentRowNeedToPrepareBinds = true;
    }

    void processCompletedBindRow(int n2, boolean bl) throws SQLException {
        int n3;
        Object object;
        Object object2;
        int n4;
        int n5;
        Binder[] binderArray;
        boolean bl2;
        if (this.numberOfBindPositions == 0) {
            return;
        }
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = bl2 = this.currentRank == this.firstRowInBatch;
        Binder[] binderArray2 = this.currentRank == 0 ? (this.lastBinders[0] == null ? null : this.lastBinders) : (binderArray = this.binders[this.currentRank - 1]);
        if (this.currentRowBindAccessors == null) {
            int n6 = n5 = this.isAutoGeneratedKey && this.clearParameters ? 1 : 0;
            if (binderArray == null) {
                for (n4 = 0; n4 < this.numberOfBindPositions; ++n4) {
                    if (this.currentRowBinders[n4] != null) continue;
                    if (n5 != 0) {
                        this.registerReturnParamsForAutoKey();
                        n5 = 0;
                        continue;
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 41, (Object)(n4 + 1));
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
            } else if (this.checkBindTypes) {
                object2 = this.currentRank == 0 ? this.lastBoundTypeOtypes : (this.parameterOtype == null ? null : this.parameterOtype[this.currentRank - 1]);
                for (n4 = 0; n4 < this.numberOfBindPositions; ++n4) {
                    if (this.currentRowBinders[n4] == null && n5 != 0) {
                        this.registerReturnParamsForAutoKey();
                        n5 = 0;
                    }
                    if ((object = this.currentRowBinders[n4]) == null) {
                        if (this.clearParameters) {
                            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 41, (Object)(n4 + 1));
                            sQLException.fillInStackTrace();
                            throw sQLException;
                        }
                        this.currentRowBinders[n4] = binderArray[n4].copyingBinder();
                        if (this.currentRank == 0) {
                            this.currentRowBinders[n4].lastBoundValueCleanup(this, n4);
                        }
                        this.currentRowCharLens[n4] = -1;
                        bl4 = true;
                    } else {
                        short s2 = ((Binder)object).type;
                        if (s2 != binderArray[n4].type || (s2 == 109 || s2 == 111) && !this.parameterOtype[this.currentRank][n4].isInHierarchyOf(object2[n4]) || s2 == 9 && ((Binder)object).bytelen == 0 != (binderArray[n4].bytelen == 0)) {
                            bl3 = true;
                        }
                    }
                    if (this.currentBatchFormOfUse[n4] == this.currentRowFormOfUse[n4]) continue;
                    bl3 = true;
                }
            } else {
                for (n4 = 0; n4 < this.numberOfBindPositions; ++n4) {
                    object2 = this.currentRowBinders[n4];
                    if (object2 != null) continue;
                    if (this.clearParameters) {
                        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 41, (Object)(n4 + 1));
                        sQLException.fillInStackTrace();
                        throw sQLException;
                    }
                    this.currentRowBinders[n4] = binderArray[n4].copyingBinder();
                    if (this.currentRank == 0) {
                        this.currentRowBinders[n4].lastBoundValueCleanup(this, n4);
                    }
                    this.currentRowCharLens[n4] = -1;
                    bl4 = true;
                }
            }
            if (bl4 && (bl2 || this.m_batchStyle == 2)) {
                this.lastBoundNeeded = true;
            }
        } else {
            Object object3;
            if (binderArray == null) {
                for (n4 = 0; n4 < this.numberOfBindPositions; ++n4) {
                    object3 = this.currentRowBinders[n4];
                    object2 = this.currentRowBindAccessors[n4];
                    if (object3 == null) {
                        if (object2 == null) {
                            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 41, (Object)(n4 + 1));
                            sQLException.fillInStackTrace();
                            throw sQLException;
                        }
                        this.currentRowBinders[n4] = this.theOutBinder;
                        continue;
                    }
                    if (object2 == null || object2.defineType == object3.type || this.connection.permitTimestampDateMismatch && object3.type == 180 && object2.defineType == 12) continue;
                    bl5 = true;
                }
            } else if (this.checkBindTypes) {
                object3 = this.currentRank == 0 ? this.lastBoundTypeOtypes : (this.parameterOtype == null ? null : this.parameterOtype[this.currentRank - 1]);
                for (n4 = 0; n4 < this.numberOfBindPositions; ++n4) {
                    Object object4;
                    object2 = this.currentRowBinders[n4];
                    object = this.currentRowBindAccessors[n4];
                    if (object2 == null) {
                        if (this.clearParameters && binderArray[n4] != this.theOutBinder) {
                            object4 = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 41, (Object)(n4 + 1));
                            ((Throwable)object4).fillInStackTrace();
                            throw object4;
                        }
                        this.currentRowBinders[n4] = object2 = binderArray[n4];
                        this.currentRowCharLens[n4] = -1;
                        if (object2 != this.theOutBinder) {
                            bl4 = true;
                        }
                    } else {
                        short s3 = object2.type;
                        if (s3 != binderArray[n4].type || (s3 == 109 || s3 == 111) && !this.parameterOtype[this.currentRank][n4].isInHierarchyOf(object3[n4]) || s3 == 9 && object2.bytelen == 0 != (binderArray[n4].bytelen == 0)) {
                            bl3 = true;
                        }
                    }
                    if (this.currentBatchFormOfUse[n4] != this.currentRowFormOfUse[n4]) {
                        bl3 = true;
                    }
                    object4 = this.currentBatchBindAccessors[n4];
                    if (object == null) {
                        this.currentRowBindAccessors[n4] = object = object4;
                    } else if (object4 != null && ((Accessor)object).defineType != ((Accessor)object4).defineType) {
                        bl3 = true;
                    }
                    if (object == null || object2 == this.theOutBinder || ((Accessor)object).defineType == object2.type || this.connection.permitTimestampDateMismatch && object2.type == 180 && ((Accessor)object).defineType == 12) continue;
                    bl5 = true;
                }
            } else {
                for (n4 = 0; n4 < this.numberOfBindPositions; ++n4) {
                    object3 = this.currentRowBinders[n4];
                    if (object3 == null) {
                        if (this.clearParameters && binderArray[n4] != this.theOutBinder) {
                            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 41, (Object)(n4 + 1));
                            sQLException.fillInStackTrace();
                            throw sQLException;
                        }
                        this.currentRowBinders[n4] = object3 = binderArray[n4];
                        this.currentRowCharLens[n4] = -1;
                        if (object3 != this.theOutBinder) {
                            bl4 = true;
                        }
                    }
                    if (this.currentRowBindAccessors[n4] != null) continue;
                    this.currentRowBindAccessors[n4] = this.currentBatchBindAccessors[n4];
                }
            }
            if (bl4 && bl2) {
                this.lastBoundNeeded = true;
            }
        }
        if (bl3) {
            if (!bl2) {
                if (this.m_batchStyle == 2) {
                    this.pushBatch(false);
                } else {
                    n5 = this.validRows;
                    this.prematureBatchCount = this.sendBatch();
                    this.validRows = n5;
                    for (n4 = 0; n4 < this.numberOfBindPositions; ++n4) {
                        this.currentRowBinders[n4].lastBoundValueCleanup(this, n4);
                    }
                    if (bl4) {
                        this.lastBoundNeeded = true;
                    }
                }
            }
            this.needToParse = true;
            this.currentRowNeedToPrepareBinds = true;
            this.needToPrepareDefineBuffer = true;
        } else if (bl) {
            this.pushBatch(false);
            this.needToParse = false;
            this.currentBatchNeedToPrepareBinds = false;
        }
        if (bl5) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        for (n4 = 0; n4 < this.numberOfBindPositions; ++n4) {
            n5 = this.currentRowCharLens[n4];
            if (n5 == -1 && this.currentRank == this.firstRowInBatch) {
                n5 = this.lastBoundCharLens[n4];
            }
            if (this.currentBatchCharLens[n4] < n5) {
                this.currentBatchCharLens[n4] = n5;
            }
            this.currentRowCharLens[n4] = 0;
            this.currentBatchFormOfUse[n4] = this.currentRowFormOfUse[n4];
        }
        if (this.currentRowNeedToPrepareBinds) {
            this.currentBatchNeedToPrepareBinds = true;
        }
        if (this.currentRowBindAccessors != null) {
            Accessor[] accessorArray = this.currentBatchBindAccessors;
            this.currentBatchBindAccessors = this.currentRowBindAccessors;
            if (accessorArray == null) {
                accessorArray = new Accessor[this.numberOfBindPositions];
            } else {
                for (n4 = 0; n4 < this.numberOfBindPositions; ++n4) {
                    accessorArray[n4] = null;
                }
            }
            this.currentRowBindAccessors = accessorArray;
        }
        if ((n3 = this.currentRank + 1) < n2) {
            if (n3 >= this.numberOfBindRowsAllocated) {
                int n7 = this.numberOfBindRowsAllocated << 1;
                if (n7 <= n3) {
                    n7 = n3 + 1;
                }
                this.growBinds(n7);
                this.currentBatchNeedToPrepareBinds = true;
                if (this.pushedBatches != null) {
                    this.pushedBatches.current_batch_need_to_prepare_binds = true;
                }
            }
            this.currentRowBinders = this.binders[n3];
        } else {
            this.setupBindBuffers(0, n2);
            this.currentRowBinders = this.binders[0];
        }
        this.currentRowNeedToPrepareBinds = false;
        this.clearParameters = false;
    }

    void processPlsqlIndexTabBinds(int n2) throws SQLException {
        int n3;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        Binder[] binderArray = this.binders[n2];
        PlsqlIbtBindInfo[] plsqlIbtBindInfoArray = this.parameterPlsqlIbt == null ? null : this.parameterPlsqlIbt[n2];
        for (n3 = 0; n3 < this.numberOfBindPositions; ++n3) {
            PlsqlIndexTableAccessor plsqlIndexTableAccessor;
            Binder binder = binderArray[n3];
            Accessor accessor = this.currentBatchBindAccessors == null ? null : this.currentBatchBindAccessors[n3];
            PlsqlIndexTableAccessor plsqlIndexTableAccessor2 = plsqlIndexTableAccessor = accessor == null || accessor.defineType != 998 ? null : (PlsqlIndexTableAccessor)accessor;
            if (binder.type == 998) {
                PlsqlIbtBindInfo plsqlIbtBindInfo = plsqlIbtBindInfoArray[n3];
                if (plsqlIndexTableAccessor != null) {
                    if (plsqlIbtBindInfo.element_internal_type != plsqlIndexTableAccessor.elementInternalType) {
                        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12);
                        sQLException.fillInStackTrace();
                        throw sQLException;
                    }
                    if (plsqlIbtBindInfo.maxLen < plsqlIndexTableAccessor.maxNumberOfElements) {
                        plsqlIbtBindInfo.maxLen = plsqlIndexTableAccessor.maxNumberOfElements;
                    }
                    if (plsqlIbtBindInfo.elemMaxLen < plsqlIndexTableAccessor.elementMaxLen) {
                        plsqlIbtBindInfo.elemMaxLen = plsqlIndexTableAccessor.elementMaxLen;
                    }
                    if (plsqlIbtBindInfo.ibtByteLength > 0) {
                        plsqlIbtBindInfo.ibtByteLength = plsqlIbtBindInfo.elemMaxLen * plsqlIbtBindInfo.maxLen;
                    } else {
                        plsqlIbtBindInfo.ibtCharLength = plsqlIbtBindInfo.elemMaxLen * plsqlIbtBindInfo.maxLen;
                    }
                }
                ++n4;
                n6 += plsqlIbtBindInfo.ibtByteLength;
                n7 += plsqlIbtBindInfo.ibtCharLength;
                n5 += plsqlIbtBindInfo.maxLen;
                continue;
            }
            if (plsqlIndexTableAccessor == null) continue;
            ++n4;
            n6 += plsqlIndexTableAccessor.ibtByteLength;
            n7 += plsqlIndexTableAccessor.ibtCharLength;
            n5 += plsqlIndexTableAccessor.maxNumberOfElements;
        }
        if (n4 == 0) {
            return;
        }
        this.ibtBindIndicatorSize = 6 + n4 * 8 + n5 * 2;
        this.ibtBindIndicators = new short[this.ibtBindIndicatorSize];
        this.ibtBindIndicatorOffset = 0;
        if (n6 > 0) {
            this.ibtBindBytes = new byte[n6];
        }
        this.ibtBindByteOffset = 0;
        if (n7 > 0) {
            this.ibtBindChars = new char[n7];
        }
        this.ibtBindCharOffset = 0;
        n3 = this.ibtBindByteOffset;
        int n8 = this.ibtBindCharOffset;
        int n9 = this.ibtBindIndicatorOffset;
        int n10 = n9 + 6 + n4 * 8;
        this.ibtBindIndicators[n9++] = (short)(n4 >> 16);
        this.ibtBindIndicators[n9++] = (short)(n4 & 0xFFFF);
        this.ibtBindIndicators[n9++] = (short)(n6 >> 16);
        this.ibtBindIndicators[n9++] = (short)(n6 & 0xFFFF);
        this.ibtBindIndicators[n9++] = (short)(n7 >> 16);
        this.ibtBindIndicators[n9++] = (short)(n7 & 0xFFFF);
        for (int i2 = 0; i2 < this.numberOfBindPositions; ++i2) {
            int n11;
            PlsqlIndexTableAccessor plsqlIndexTableAccessor;
            Binder binder = binderArray[i2];
            Accessor accessor = this.currentBatchBindAccessors == null ? null : this.currentBatchBindAccessors[i2];
            PlsqlIndexTableAccessor plsqlIndexTableAccessor3 = plsqlIndexTableAccessor = accessor == null || accessor.defineType != 998 ? null : (PlsqlIndexTableAccessor)accessor;
            if (binder.type == 998) {
                PlsqlIbtBindInfo plsqlIbtBindInfo = plsqlIbtBindInfoArray[i2];
                int n12 = plsqlIbtBindInfo.maxLen;
                this.ibtBindIndicators[n9++] = (short)plsqlIbtBindInfo.element_internal_type;
                this.ibtBindIndicators[n9++] = (short)plsqlIbtBindInfo.elemMaxLen;
                this.ibtBindIndicators[n9++] = (short)(n12 >> 16);
                this.ibtBindIndicators[n9++] = (short)(n12 & 0xFFFF);
                this.ibtBindIndicators[n9++] = (short)(plsqlIbtBindInfo.curLen >> 16);
                this.ibtBindIndicators[n9++] = (short)(plsqlIbtBindInfo.curLen & 0xFFFF);
                if (plsqlIbtBindInfo.ibtByteLength > 0) {
                    n11 = n3;
                    n3 += plsqlIbtBindInfo.ibtByteLength;
                } else {
                    n11 = n8;
                    n8 += plsqlIbtBindInfo.ibtCharLength;
                }
                this.ibtBindIndicators[n9++] = (short)(n11 >> 16);
                this.ibtBindIndicators[n9++] = (short)(n11 & 0xFFFF);
                plsqlIbtBindInfo.ibtValueIndex = n11;
                plsqlIbtBindInfo.ibtIndicatorIndex = n10;
                plsqlIbtBindInfo.ibtLengthIndex = n10 + n12;
                if (plsqlIndexTableAccessor != null) {
                    plsqlIndexTableAccessor.ibtIndicatorIndex = plsqlIbtBindInfo.ibtIndicatorIndex;
                    plsqlIndexTableAccessor.ibtLengthIndex = plsqlIbtBindInfo.ibtLengthIndex;
                    plsqlIndexTableAccessor.ibtMetaIndex = n9 - 8;
                    plsqlIndexTableAccessor.ibtValueIndex = n11;
                }
                n10 += 2 * n12;
                continue;
            }
            if (plsqlIndexTableAccessor == null) continue;
            int n13 = plsqlIndexTableAccessor.maxNumberOfElements;
            this.ibtBindIndicators[n9++] = (short)plsqlIndexTableAccessor.elementInternalType;
            this.ibtBindIndicators[n9++] = (short)plsqlIndexTableAccessor.elementMaxLen;
            this.ibtBindIndicators[n9++] = (short)(n13 >> 16);
            this.ibtBindIndicators[n9++] = (short)(n13 & 0xFFFF);
            this.ibtBindIndicators[n9++] = 0;
            this.ibtBindIndicators[n9++] = 0;
            if (plsqlIndexTableAccessor.ibtByteLength > 0) {
                n11 = n3;
                n3 += plsqlIndexTableAccessor.ibtByteLength;
            } else {
                n11 = n8;
                n8 += plsqlIndexTableAccessor.ibtCharLength;
            }
            this.ibtBindIndicators[n9++] = (short)(n11 >> 16);
            this.ibtBindIndicators[n9++] = (short)(n11 & 0xFFFF);
            plsqlIndexTableAccessor.ibtValueIndex = n11;
            plsqlIndexTableAccessor.ibtIndicatorIndex = n10;
            plsqlIndexTableAccessor.ibtLengthIndex = n10 + n13;
            plsqlIndexTableAccessor.ibtMetaIndex = n9 - 8;
            n10 += 2 * n13;
        }
    }

    void initializeBindSubRanges(int n2, int n3) {
        this.bindByteSubRange = 0;
        this.bindCharSubRange = 0;
    }

    int calculateIndicatorSubRangeSize() {
        return 0;
    }

    short getInoutIndicator(int n2) {
        return 0;
    }

    @Override
    void initializeIndicatorSubRange() {
        this.bindIndicatorSubRange = this.calculateIndicatorSubRangeSize();
    }

    void prepareBindPreambles(int n2, int n3) {
    }

    void setupBindBuffers(int n2, int n3) throws SQLException {
        try {
            Object object;
            int n4;
            int n5;
            int n6;
            int n7;
            int n8;
            int n9;
            int n10;
            if (this.numberOfBindPositions == 0) {
                if (n3 != 0) {
                    if (this.bindIndicators == null) {
                        this.allocBinds(n3);
                    }
                    this.numberOfBoundRows = n3;
                    this.bindIndicators[this.bindIndicatorSubRange + 3] = (short)((this.numberOfBoundRows & 0xFFFF0000) >> 16);
                    this.bindIndicators[this.bindIndicatorSubRange + 4] = (short)(this.numberOfBoundRows & 0xFFFF);
                }
                return;
            }
            this.preparedAllBinds = this.currentBatchNeedToPrepareBinds;
            this.preparedCharBinds = false;
            this.currentBatchNeedToPrepareBinds = false;
            this.numberOfBoundRows = n3;
            this.bindIndicators[this.bindIndicatorSubRange + 3] = (short)((this.numberOfBoundRows & 0xFFFF0000) >> 16);
            this.bindIndicators[this.bindIndicatorSubRange + 4] = (short)(this.numberOfBoundRows & 0xFFFF);
            int n11 = this.bindBufferCapacity;
            if (this.numberOfBoundRows > this.bindBufferCapacity) {
                n11 = this.numberOfBoundRows;
                this.preparedAllBinds = true;
            }
            if (this.currentBatchBindAccessors != null) {
                if (this.outBindAccessors == null) {
                    this.outBindAccessors = new Accessor[this.numberOfBindPositions];
                }
                for (n10 = 0; n10 < this.numberOfBindPositions; ++n10) {
                    Accessor accessor;
                    this.outBindAccessors[n10] = accessor = this.currentBatchBindAccessors[n10];
                    if (accessor == null || (n9 = accessor.charLength) != 0 && this.currentBatchCharLens[n10] >= n9) continue;
                    this.currentBatchCharLens[n10] = n9;
                }
            }
            int n12 = 0;
            n9 = 0;
            int n13 = n8 = this.bindIndicatorSubRange + 5;
            if (this.preparedAllBinds) {
                this.preparedCharBinds = true;
                Binder[] binderArray = this.binders[n2];
                for (n10 = 0; n10 < this.numberOfBindPositions; ++n10) {
                    Binder binder = binderArray[n10];
                    n7 = this.currentBatchCharLens[n10];
                    if (binder == this.theOutBinder) {
                        Accessor accessor = this.currentBatchBindAccessors[n10];
                        n6 = accessor.byteLength;
                        n5 = (short)accessor.defineType;
                    } else {
                        n6 = binder.bytelen;
                        n5 = binder.type;
                    }
                    n9 += n6;
                    n12 += n7;
                    this.bindIndicators[n13 + 0] = n5;
                    this.bindIndicators[n13 + 1] = (short)n6;
                    this.bindIndicators[n13 + 2] = (short)n7;
                    this.bindIndicators[n13 + 9] = this.currentBatchFormOfUse[n10];
                    n13 += 10;
                }
            } else if (this.preparedCharBinds) {
                for (n10 = 0; n10 < this.numberOfBindPositions; ++n10) {
                    int n14 = this.currentBatchCharLens[n10];
                    n12 += n14;
                    this.bindIndicators[n13 + 2] = (short)n14;
                    n13 += 10;
                }
            } else {
                for (n10 = 0; n10 < this.numberOfBindPositions; ++n10) {
                    int n15 = n13 + 2;
                    int n16 = this.currentBatchCharLens[n10];
                    n5 = this.bindIndicators[n15];
                    n6 = (this.bindIndicators[n13 + 5] << 16) + (this.bindIndicators[n13 + 6] & 0xFFFF);
                    int n17 = n7 = this.bindIndicators[n6] == -1 ? 1 : 0;
                    if (n7 != 0 && n16 > 1) {
                        this.preparedCharBinds = true;
                    }
                    if (n5 >= n16 && !this.preparedCharBinds) {
                        this.currentBatchCharLens[n10] = n5;
                        n12 += n5;
                    } else {
                        this.bindIndicators[n15] = (short)n16;
                        n12 += n16;
                        this.preparedCharBinds = true;
                    }
                    n13 += 10;
                }
            }
            if (this.preparedCharBinds) {
                this.initializeBindSubRanges(this.numberOfBoundRows, n11);
            }
            if (this.preparedAllBinds) {
                int n18 = this.bindByteSubRange + n9 * n11;
                if (this.lastBoundNeeded || n18 > this.totalBindByteLength) {
                    this.bindByteOffset = 0;
                    this.bindBytes = this.connection.getByteBuffer(n18);
                    this.totalBindByteLength = n18;
                }
                this.bindBufferCapacity = n11;
                this.bindIndicators[this.bindIndicatorSubRange + 1] = (short)((this.bindBufferCapacity & 0xFFFF0000) >> 16);
                this.bindIndicators[this.bindIndicatorSubRange + 2] = (short)(this.bindBufferCapacity & 0xFFFF);
            }
            if (this.preparedCharBinds) {
                int n19 = this.bindCharSubRange + n12 * this.bindBufferCapacity;
                if (this.lastBoundNeeded || n19 > this.totalBindCharLength) {
                    this.bindCharOffset = 0;
                    this.bindChars = this.connection.getCharBuffer(n19);
                    this.totalBindCharLength = n19;
                }
                this.bindByteSubRange += this.bindByteOffset;
                this.bindCharSubRange += this.bindCharOffset;
            }
            int n20 = this.bindByteSubRange;
            int n21 = this.bindCharSubRange;
            n5 = this.indicatorsOffset;
            n6 = this.valueLengthsOffset;
            n13 = n8;
            if (this.preparedCharBinds) {
                if (this.currentBatchBindAccessors == null) {
                    for (n10 = 0; n10 < this.numberOfBindPositions; ++n10) {
                        n7 = this.bindIndicators[n13 + 1];
                        int n22 = this.currentBatchCharLens[n10];
                        n4 = n22 == 0 ? n20 : n21;
                        this.bindIndicators[n13 + 3] = (short)(n4 >> 16);
                        this.bindIndicators[n13 + 4] = (short)(n4 & 0xFFFF);
                        n20 += n7 * this.bindBufferCapacity;
                        n21 += n22 * this.bindBufferCapacity;
                        n13 += 10;
                    }
                } else {
                    for (n10 = 0; n10 < this.numberOfBindPositions; ++n10) {
                        n7 = this.bindIndicators[n13 + 1];
                        int n23 = this.currentBatchCharLens[n10];
                        n4 = n23 == 0 ? n20 : n21;
                        this.bindIndicators[n13 + 3] = (short)(n4 >> 16);
                        this.bindIndicators[n13 + 4] = (short)(n4 & 0xFFFF);
                        object = this.currentBatchBindAccessors[n10];
                        if (object != null) {
                            if (n23 > 0) {
                                ((Accessor)object).columnIndex = n21;
                                ((Accessor)object).charLength = n23;
                            } else {
                                ((Accessor)object).columnIndex = n20;
                                ((Accessor)object).byteLength = n7;
                            }
                            ((Accessor)object).lengthIndex = n6;
                            ((Accessor)object).indicatorIndex = n5;
                            ((Accessor)object).rowSpaceByte = this.bindBytes;
                            ((Accessor)object).rowSpaceChar = this.bindChars;
                            ((Accessor)object).rowSpaceIndicator = this.bindIndicators;
                            if (((Accessor)object).defineType == 109 || ((Accessor)object).defineType == 111) {
                                ((Accessor)object).setOffsets(this.bindBufferCapacity);
                            }
                        }
                        n20 += n7 * this.bindBufferCapacity;
                        n21 += n23 * this.bindBufferCapacity;
                        n5 += this.numberOfBindRowsAllocated;
                        n6 += this.numberOfBindRowsAllocated;
                        n13 += 10;
                    }
                }
                n20 = this.bindByteSubRange;
                n21 = this.bindCharSubRange;
                n5 = this.indicatorsOffset;
                n6 = this.valueLengthsOffset;
                n13 = n8;
            }
            n7 = this.bindBufferCapacity - this.numberOfBoundRows;
            int n24 = this.numberOfBoundRows - 1;
            n4 = n24 + n2;
            object = this.binders[n4];
            if (this.parameterOtype != null) {
                System.arraycopy(this.parameterDatum[n4], 0, this.lastBoundTypeBytes, 0, this.numberOfBindPositions);
                System.arraycopy(this.parameterOtype[n4], 0, this.lastBoundTypeOtypes, 0, this.numberOfBindPositions);
            }
            if (this.hasIbtBind) {
                this.processPlsqlIndexTabBinds(n2);
            }
            if (this.numReturnParams > 0 && (this.returnParamAccessors == null || this.returnParamAccessors.length < this.numReturnParams)) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 173);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.returnParamAccessors != null) {
                this.processDmlReturningBind();
            }
            boolean bl = !this.sqlKind.isPlsqlOrCall() || this.currentRowBindAccessors == null;
            for (n10 = 0; n10 < this.numberOfBindPositions; ++n10) {
                int n25 = this.bindIndicators[n13 + 1];
                int n26 = this.currentBatchCharLens[n10];
                this.lastBinders[n10] = object[n10];
                this.lastBoundByteLens[n10] = n25;
                for (int i2 = 0; i2 < this.numberOfBoundRows; ++i2) {
                    int n27 = n2 + i2;
                    this.binders[n27][n10].bind(this, n10, i2, n27, this.bindBytes, this.bindChars, this.bindIndicators, n25, n26, n20, n21, n6 + i2, n5 + i2, bl);
                    this.binders[n27][n10] = null;
                    if (this.userStream != null) {
                        this.userStream[i2][n10] = null;
                    }
                    n20 += n25;
                    n21 += n26;
                }
                this.lastBoundByteOffsets[n10] = n20 - n25;
                this.lastBoundCharOffsets[n10] = n21 - n26;
                this.lastBoundInds[n10] = this.bindIndicators[n5 + n24];
                this.lastBoundLens[n10] = this.bindIndicators[n6 + n24];
                this.lastBoundCharLens[n10] = 0;
                n20 += n7 * n25;
                n21 += n7 * n26;
                n5 += this.numberOfBindRowsAllocated;
                n6 += this.numberOfBindRowsAllocated;
                n13 += 10;
            }
            this.lastBoundBytes = this.bindBytes;
            this.lastBoundByteOffset = this.bindByteOffset;
            this.lastBoundChars = this.bindChars;
            this.lastBoundCharOffset = this.bindCharOffset;
            if (this.parameterStream != null) {
                this.lastBoundStream = this.parameterStream[n2 + this.numberOfBoundRows - 1];
            }
            int[] nArray = this.currentBatchCharLens;
            this.currentBatchCharLens = this.lastBoundCharLens;
            this.lastBoundCharLens = nArray;
            this.lastBoundNeeded = false;
            this.prepareBindPreambles(this.numberOfBoundRows, this.bindBufferCapacity);
        }
        catch (NullPointerException nullPointerException) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 89);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    @Override
    void releaseBuffers() {
        int n2 = this.cachedBindCharSize = this.bindChars != null ? this.bindChars.length : 0;
        if (this.bindChars != this.lastBoundChars) {
            this.connection.cacheBuffer(this.lastBoundChars);
        }
        this.lastBoundChars = null;
        this.connection.cacheBuffer(this.bindChars);
        this.bindChars = null;
        int n3 = this.cachedBindByteSize = this.bindBytes != null ? this.bindBytes.length : 0;
        if (this.bindBytes != this.lastBoundBytes) {
            this.connection.cacheBuffer(this.lastBoundBytes);
        }
        this.lastBoundBytes = null;
        this.connection.cacheBuffer(this.bindBytes);
        this.bindBytes = null;
        super.releaseBuffers();
    }

    @Override
    public void enterImplicitCache() throws SQLException {
        this.alwaysOnClose();
        if (!this.connection.isClosed()) {
            this.cleanAllTempLobs();
        }
        if (this.connection.clearStatementMetaData) {
            this.lastBoundBytes = null;
            this.lastBoundChars = null;
        }
        this.clearParameters();
        this.cacheState = 2;
        this.creationState = 1;
        this.currentResultSet = null;
        this.lastIndex = 0;
        this.queryTimeout = 0;
        this.autoRollback = 2;
        this.rowPrefetchChanged = false;
        this.currentRank = 0;
        this.currentRow = -1;
        this.validRows = 0;
        this.maxRows = 0;
        this.totalRowsVisited = 0;
        this.maxFieldSize = 0;
        this.gotLastBatch = false;
        this.clearParameters = true;
        this.scrollRset = null;
        this.defaultFetchDirection = 1000;
        this.defaultTimeZone = null;
        this.defaultCalendar = null;
        this.checkSum = 0L;
        this.checkSumComputationFailure = false;
        if (this.sqlKind.isOTHER()) {
            this.needToParse = true;
            this.needToPrepareDefineBuffer = true;
            this.columnsDefinedByUser = false;
        }
        this.releaseBuffers();
        this.definedColumnType = null;
        this.definedColumnSize = null;
        this.definedColumnFormOfUse = null;
        if (this.accessors != null) {
            int n2 = this.accessors.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (this.accessors[i2] == null) continue;
                this.accessors[i2].rowSpaceByte = null;
                this.accessors[i2].rowSpaceChar = null;
                this.accessors[i2].rowSpaceIndicator = null;
                if (!this.columnsDefinedByUser) continue;
                this.accessors[i2].externalType = 0;
            }
        }
        this.fixedString = this.connection.getDefaultFixedString();
        this.defaultRowPrefetch = this.rowPrefetch;
        this.rowPrefetchInLastFetch = -1;
        if (this.connection.clearStatementMetaData) {
            this.sqlStringChanged = true;
            this.needToParse = true;
            this.needToPrepareDefineBuffer = true;
            this.columnsDefinedByUser = false;
            if (this.userRsetType == 0) {
                this.userRsetType = 1;
                this.realRsetType = 1;
            }
            this.currentRowNeedToPrepareBinds = true;
        }
    }

    @Override
    public void enterExplicitCache() throws SQLException {
        this.cacheState = 2;
        this.creationState = 2;
        this.defaultTimeZone = null;
        this.alwaysOnClose();
    }

    @Override
    public void exitImplicitCacheToActive() throws SQLException {
        this.cacheState = 1;
        this.closed = false;
        if (this.rowPrefetch != this.connection.getDefaultRowPrefetch() && this.streamList == null) {
            this.defaultRowPrefetch = this.rowPrefetch = this.connection.getDefaultRowPrefetch();
            this.rowPrefetchChanged = true;
        }
        if (this.batch != this.connection.getDefaultExecuteBatch()) {
            this.resetBatch();
        }
        this.processEscapes = this.connection.processEscapes;
        if (this.cachedDefineIndicatorSize != 0) {
            this.defineBytes = this.connection.getByteBuffer(this.cachedDefineByteSize);
            this.defineChars = this.connection.getCharBuffer(this.cachedDefineCharSize);
            this.defineIndicators = new short[this.cachedDefineIndicatorSize];
            if (this.accessors != null) {
                int n2 = this.accessors.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (this.accessors[i2] == null) continue;
                    this.accessors[i2].rowSpaceByte = this.defineBytes;
                    this.accessors[i2].rowSpaceChar = this.defineChars;
                    this.accessors[i2].rowSpaceIndicator = this.defineIndicators;
                }
                this.doInitializationAfterDefineBufferRestore();
            }
        }
        if (this.cachedBindCharSize != 0 || this.cachedBindByteSize != 0) {
            if (this.cachedBindByteSize > 0) {
                this.bindBytes = this.connection.getByteBuffer(this.cachedBindByteSize);
            }
            if (this.cachedBindCharSize > 0) {
                this.bindChars = this.connection.getCharBuffer(this.cachedBindCharSize);
            }
            this.doLocalInitialization();
        }
    }

    void doLocalInitialization() {
    }

    void doInitializationAfterDefineBufferRestore() {
    }

    @Override
    public void exitExplicitCacheToActive() throws SQLException {
        this.cacheState = 1;
        this.closed = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exitImplicitCacheToClose() throws SQLException {
        this.cacheState = 0;
        this.closed = false;
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.hardClose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exitExplicitCacheToClose() throws SQLException {
        this.cacheState = 0;
        this.closed = false;
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.hardClose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeWithKey(String string) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.closeOrCache(string);
        }
    }

    int executeInternal() throws SQLException {
        boolean bl;
        this.noMoreUpdateCounts = false;
        this.checkSum = 0L;
        this.checkSumComputationFailure = false;
        this.ensureOpen();
        if (this.currentRank > 0 && this.m_batchStyle == 2) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 81, "batch must be either executed or cleared");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        boolean bl2 = this.userRsetType == 1;
        this.prepareForNewResults(true, false);
        this.processCompletedBindRow(this.sqlKind.isSELECT() ? 1 : this.batch, false);
        if (!bl2 && !this.scrollRsetTypeSolved) {
            return this.doScrollPstmtExecuteUpdate() + this.prematureBatchCount;
        }
        this.doExecuteWithTimeout();
        boolean bl3 = bl = this.prematureBatchCount != 0 && this.validRows > 0;
        if (!bl2) {
            this.currentResultSet = new OracleResultSetImpl(this.connection, this);
            this.scrollRset = ResultSetUtil.createScrollResultSet(this, this.currentResultSet, this.realRsetType);
            if (!this.connection.accumulateBatchResult) {
                bl = false;
            }
        }
        if (bl) {
            this.validRows += this.prematureBatchCount;
            this.prematureBatchCount = 0;
        }
        if (this.sqlKind.isOTHER()) {
            this.needToParse = true;
        }
        return this.validRows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet executeQuery() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.executionType = 1;
            this.executeInternal();
            if (this.userRsetType == 1) {
                this.currentResultSet = new OracleResultSetImpl(this.connection, this);
                return this.currentResultSet;
            }
            if (this.scrollRset == null) {
                this.currentResultSet = new OracleResultSetImpl(this.connection, this);
                this.scrollRset = this.currentResultSet;
            }
            return this.scrollRset;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.executionType = (byte)2;
            return this.executeInternal();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.executionType = (byte)3;
            this.executeInternal();
            return this.sqlKind.isSELECT();
        }
    }

    void slideDownCurrentRow(int n2) {
        Object object;
        if (this.binders != null) {
            this.binders[n2] = this.binders[0];
            this.binders[0] = this.currentRowBinders;
        }
        if (this.parameterInt != null) {
            object = this.parameterInt[0];
            this.parameterInt[0] = this.parameterInt[n2];
            this.parameterInt[n2] = object;
        }
        if (this.parameterLong != null) {
            object = this.parameterLong[0];
            this.parameterLong[0] = this.parameterLong[n2];
            this.parameterLong[n2] = object;
        }
        if (this.parameterFloat != null) {
            object = this.parameterFloat[0];
            this.parameterFloat[0] = this.parameterFloat[n2];
            this.parameterFloat[n2] = object;
        }
        if (this.parameterDouble != null) {
            object = this.parameterDouble[0];
            this.parameterDouble[0] = this.parameterDouble[n2];
            this.parameterDouble[n2] = object;
        }
        if (this.parameterBigDecimal != null) {
            object = this.parameterBigDecimal[0];
            this.parameterBigDecimal[0] = this.parameterBigDecimal[n2];
            this.parameterBigDecimal[n2] = (BigDecimal[])object;
        }
        if (this.parameterString != null) {
            object = this.parameterString[0];
            this.parameterString[0] = this.parameterString[n2];
            this.parameterString[n2] = (String[])object;
        }
        if (this.parameterDate != null) {
            object = this.parameterDate[0];
            this.parameterDate[0] = this.parameterDate[n2];
            this.parameterDate[n2] = (Date[])object;
        }
        if (this.parameterTime != null) {
            object = this.parameterTime[0];
            this.parameterTime[0] = this.parameterTime[n2];
            this.parameterTime[n2] = (Time[])object;
        }
        if (this.parameterTimestamp != null) {
            object = this.parameterTimestamp[0];
            this.parameterTimestamp[0] = this.parameterTimestamp[n2];
            this.parameterTimestamp[n2] = (Timestamp[])object;
        }
        if (this.parameterDatum != null) {
            object = this.parameterDatum[0];
            this.parameterDatum[0] = this.parameterDatum[n2];
            this.parameterDatum[n2] = (byte[][])object;
        }
        if (this.parameterOtype != null) {
            object = this.parameterOtype[0];
            this.parameterOtype[0] = this.parameterOtype[n2];
            this.parameterOtype[n2] = (OracleTypeADT[])object;
        }
        if (this.parameterStream != null) {
            object = this.parameterStream[0];
            this.parameterStream[0] = this.parameterStream[n2];
            this.parameterStream[n2] = (InputStream[])object;
        }
        if (this.userStream != null) {
            object = this.userStream[0];
            this.userStream[0] = this.userStream[n2];
            this.userStream[n2] = object;
        }
    }

    void resetBatch() {
        this.batch = this.connection.getDefaultExecuteBatch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int sendBatch() throws SQLException {
        if (this.isJdbcBatchStyle()) {
            return 0;
        }
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                int n2;
                this.ensureOpen();
                if (this.currentRank <= 0) {
                    int n3 = this.connection.accumulateBatchResult ? 0 : this.validRows;
                    return n3;
                }
                int n4 = this.batch;
                try {
                    n2 = this.currentRank;
                    if (this.batch != this.currentRank) {
                        this.batch = this.currentRank;
                    }
                    this.setupBindBuffers(0, this.currentRank);
                    --this.currentRank;
                    this.doExecuteWithTimeout();
                    this.slideDownCurrentRow(n2);
                }
                finally {
                    if (this.batch != n4) {
                        this.batch = n4;
                    }
                }
                if (this.connection.accumulateBatchResult) {
                    this.validRows += this.prematureBatchCount;
                    this.prematureBatchCount = 0;
                }
                n2 = this.validRows;
                return n2;
            }
            finally {
                this.currentRank = 0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setExecuteBatch(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.setOracleBatchStyle();
            this.set_execute_batch(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void set_execute_batch(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            int n3;
            if (n2 <= 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 42);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 == this.batch) {
                return;
            }
            if (this.currentRank > 0) {
                n3 = this.validRows;
                this.prematureBatchCount = this.sendBatch();
                this.validRows = n3;
            }
            n3 = this.batch;
            this.batch = n2;
            if (this.numberOfBindRowsAllocated < this.batch) {
                this.growBinds(this.batch);
            }
        }
    }

    @Override
    public final int getExecuteBatch() {
        return this.batch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void defineParameterTypeBytes(int n2, int n3, int n4) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (n4 < 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 53);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 < 1) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            switch (n3) {
                case -7: 
                case -6: 
                case -5: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    n3 = 6;
                    break;
                }
                case 1: {
                    n3 = 96;
                    break;
                }
                case 12: {
                    n3 = 1;
                    break;
                }
                case 91: 
                case 92: {
                    n3 = 12;
                    break;
                }
                case -103: {
                    n3 = 182;
                    break;
                }
                case -104: {
                    n3 = 183;
                    break;
                }
                case -100: 
                case 93: {
                    n3 = 180;
                    break;
                }
                case -101: {
                    n3 = 181;
                    break;
                }
                case -102: {
                    n3 = 231;
                    break;
                }
                case -3: 
                case -2: {
                    n3 = 23;
                    break;
                }
                case 100: {
                    n3 = 100;
                    break;
                }
                case 101: {
                    n3 = 101;
                    break;
                }
                case -8: {
                    n3 = 104;
                    break;
                }
                case 2004: {
                    n3 = 113;
                    break;
                }
                case 2005: {
                    n3 = 112;
                    break;
                }
                case -13: {
                    n3 = 114;
                    break;
                }
                case -10: {
                    n3 = 102;
                    break;
                }
                case 0: {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                default: {
                    SQLException sQLException = DatabaseError.createUnsupportedFeatureSqlException();
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void defineParameterTypeChars(int n2, int n3, int n4) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            int n5 = this.connection.getNlsRatio();
            if (n3 == 1 || n3 == 12) {
                this.defineParameterTypeBytes(n2, n3, n4 * n5);
            } else {
                this.defineParameterTypeBytes(n2, n3, n4);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void defineParameterType(int n2, int n3, int n4) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.defineParameterTypeBytes(n2, n3, n4);
        }
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        if (this.sqlObject.getSqlKind().isSELECT()) {
            return new OracleResultSetMetaData(this.connection, this);
        }
        return null;
    }

    @Override
    public void setNull(int n2, int n3, String string) throws SQLException {
        this.setNullInternal(n2, n3, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setNullInternal(int n2, int n3, String string) throws SQLException {
        int n4 = n2 - 1;
        if (n4 < 0 || n2 > this.numberOfBindPositions) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (n3 == 2002 || n3 == 2008 || n3 == 2003 || n3 == 2007 || n3 == 2009 || n3 == 2006) {
            PhysicalConnection physicalConnection = this.connection;
            synchronized (physicalConnection) {
                this.setNullCritical(n4, n3, string);
                this.currentRowCharLens[n4] = 0;
            }
        } else {
            this.setNullInternal(n2, n3);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setNullInternal(int n2, int n3) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.setNullCritical(n2, n3);
        }
    }

    void setNullCritical(int n2, int n3, String string) throws SQLException {
        OracleTypeADT oracleTypeADT = null;
        Binder binder = this.theNamedTypeNullBinder;
        switch (n3) {
            case 2006: {
                binder = this.theRefTypeNullBinder;
            }
            case 2002: 
            case 2008: {
                StructDescriptor structDescriptor = StructDescriptor.createDescriptor(string, (Connection)this.connection);
                oracleTypeADT = structDescriptor.getOracleTypeADT();
                break;
            }
            case 2003: {
                ArrayDescriptor arrayDescriptor = ArrayDescriptor.createDescriptor(string, (Connection)this.connection);
                oracleTypeADT = arrayDescriptor.getOracleTypeCOLLECTION();
                break;
            }
            case 2007: 
            case 2009: {
                OpaqueDescriptor opaqueDescriptor = OpaqueDescriptor.createDescriptor(string, (Connection)this.connection);
                oracleTypeADT = (OracleTypeADT)opaqueDescriptor.getPickler();
                break;
            }
        }
        this.currentRowBinders[n2] = binder;
        if (this.parameterDatum == null) {
            this.parameterDatum = new byte[this.numberOfBindRowsAllocated][this.numberOfBindPositions][];
        }
        this.parameterDatum[this.currentRank][n2] = null;
        if (oracleTypeADT != null) {
            oracleTypeADT.getTOID();
        }
        if (this.parameterOtype == null) {
            this.parameterOtype = new OracleTypeADT[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
        }
        this.parameterOtype[this.currentRank][n2] = oracleTypeADT;
    }

    @Override
    public void setNullAtName(String string, int n2, String string2) throws SQLException {
        String string3 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl = false;
        int n3 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n3; ++i2) {
            if (stringArray[i2] != string3) continue;
            this.setNullInternal(i2 + 1, n2, string2);
            bl = true;
        }
        if (!bl) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNull(int n2, int n3) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.setNullCritical(n2, n3);
        }
    }

    void setNullCritical(int n2, int n3) throws SQLException {
        int n4 = n2 - 1;
        if (n4 < 0 || n2 > this.numberOfBindPositions) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        Binder binder = null;
        int n5 = this.getInternalType(n3);
        switch (n5) {
            case 6: {
                binder = this.theVarnumNullBinder;
                break;
            }
            case 1: 
            case 8: 
            case 96: 
            case 995: {
                binder = this.theVarcharNullBinder;
                this.currentRowCharLens[n4] = 1;
                break;
            }
            case 999: {
                binder = this.theFixedCHARNullBinder;
                break;
            }
            case 12: {
                binder = this.theDateNullBinder;
                break;
            }
            case 180: {
                binder = this.theTimestampNullBinder;
                break;
            }
            case 181: {
                binder = this.theTSTZNullBinder;
                break;
            }
            case 231: {
                binder = this.theTSLTZNullBinder;
                break;
            }
            case 104: {
                binder = this.getRowidNullBinder(n4);
                break;
            }
            case 183: {
                binder = this.theIntervalDSNullBinder;
                break;
            }
            case 182: {
                binder = this.theIntervalYMNullBinder;
                break;
            }
            case 23: 
            case 24: {
                binder = this.theRawNullBinder;
                break;
            }
            case 100: {
                binder = this.theBinaryFloatNullBinder;
                break;
            }
            case 101: {
                binder = this.theBinaryDoubleNullBinder;
                break;
            }
            case 113: {
                binder = this.theBlobNullBinder;
                break;
            }
            case 112: {
                binder = this.theClobNullBinder;
                break;
            }
            case 114: {
                binder = this.theBfileNullBinder;
                break;
            }
            case 109: 
            case 111: {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "sqlType=" + n3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            default: {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 23, "sqlType=" + n3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        }
        this.currentRowBinders[n4] = binder;
    }

    Binder getRowidNullBinder(int n2) {
        return this.theRowidNullBinder;
    }

    @Override
    public void setNullAtName(String string, int n2) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl = false;
        int n3 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n3; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setNull(i2 + 1, n2);
            bl = true;
        }
        if (!bl) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBoolean(int n2, boolean bl) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.setBooleanInternal(n2, bl);
        }
    }

    void setBooleanInternal(int n2, boolean bl) throws SQLException {
        int n3 = n2 - 1;
        if (n3 < 0 || n2 > this.numberOfBindPositions) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.currentRowCharLens[n3] = 0;
        this.currentRowBinders[n3] = this.theBooleanBinder;
        if (this.parameterInt == null) {
            this.parameterInt = new int[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
        }
        this.parameterInt[this.currentRank][n3] = bl ? 1 : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setByte(int n2, byte by) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.setByteInternal(n2, by);
        }
    }

    void setByteInternal(int n2, byte by) throws SQLException {
        int n3 = n2 - 1;
        if (n3 < 0 || n2 > this.numberOfBindPositions) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.currentRowCharLens[n3] = 0;
        this.currentRowBinders[n3] = this.theByteBinder;
        if (this.parameterInt == null) {
            this.parameterInt = new int[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
        }
        this.parameterInt[this.currentRank][n3] = by;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setShort(int n2, short s2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.setShortInternal(n2, s2);
        }
    }

    void setShortInternal(int n2, short s2) throws SQLException {
        int n3 = n2 - 1;
        if (n3 < 0 || n2 > this.numberOfBindPositions) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.currentRowCharLens[n3] = 0;
        this.currentRowBinders[n3] = this.theShortBinder;
        if (this.parameterInt == null) {
            this.parameterInt = new int[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
        }
        this.parameterInt[this.currentRank][n3] = s2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setInt(int n2, int n3) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.setIntInternal(n2, n3);
        }
    }

    void setIntInternal(int n2, int n3) throws SQLException {
        int n4 = n2 - 1;
        if (n4 < 0 || n2 > this.numberOfBindPositions) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.currentRowCharLens[n4] = 0;
        this.currentRowBinders[n4] = this.theIntBinder;
        if (this.parameterInt == null) {
            this.parameterInt = new int[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
        }
        this.parameterInt[this.currentRank][n4] = n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLong(int n2, long l2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.setLongInternal(n2, l2);
        }
    }

    void setLongInternal(int n2, long l2) throws SQLException {
        int n3 = n2 - 1;
        if (n3 < 0 || n2 > this.numberOfBindPositions) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.currentRowCharLens[n3] = 0;
        this.currentRowBinders[n3] = this.theLongBinder;
        if (this.parameterLong == null) {
            this.parameterLong = new long[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
        }
        this.parameterLong[this.currentRank][n3] = l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFloat(int n2, float f2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.setFloatInternal(n2, f2);
        }
    }

    void setFloatInternal(int n2, float f2) throws SQLException {
        int n3 = n2 - 1;
        if (n3 < 0 || n2 > this.numberOfBindPositions) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.theFloatBinder == null) {
            this.theFloatBinder = theStaticFloatBinder;
            if (this.connection.setFloatAndDoubleUseBinary) {
                this.theFloatBinder = theStaticBinaryFloatBinder;
            }
        }
        this.currentRowCharLens[n3] = 0;
        this.currentRowBinders[n3] = this.theFloatBinder;
        if (this.theFloatBinder == theStaticFloatBinder) {
            if (this.parameterDouble == null) {
                this.parameterDouble = new double[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
            }
            this.parameterDouble[this.currentRank][n3] = f2;
        } else {
            if (this.parameterFloat == null) {
                this.parameterFloat = new float[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
            }
            this.parameterFloat[this.currentRank][n3] = f2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBinaryFloat(int n2, float f2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.setBinaryFloatInternal(n2, f2);
        }
    }

    void setBinaryFloatInternal(int n2, float f2) throws SQLException {
        int n3 = n2 - 1;
        if (n3 < 0 || n2 > this.numberOfBindPositions) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.currentRowCharLens[n3] = 0;
        this.currentRowBinders[n3] = this.theBinaryFloatBinder;
        if (this.parameterFloat == null) {
            this.parameterFloat = new float[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
        }
        this.parameterFloat[this.currentRank][n3] = f2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBinaryFloat(int n2, BINARY_FLOAT bINARY_FLOAT) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.setBinaryFloatInternal(n2, bINARY_FLOAT);
        }
    }

    void setBinaryFloatInternal(int n2, BINARY_FLOAT bINARY_FLOAT) throws SQLException {
        int n3 = n2 - 1;
        if (n3 < 0 || n2 > this.numberOfBindPositions) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (bINARY_FLOAT == null) {
            this.currentRowBinders[n3] = this.theBINARY_FLOATNullBinder;
        } else {
            this.currentRowBinders[n3] = this.theBINARY_FLOATBinder;
            if (this.parameterDatum == null) {
                this.parameterDatum = new byte[this.numberOfBindRowsAllocated][this.numberOfBindPositions][];
            }
            this.parameterDatum[this.currentRank][n3] = bINARY_FLOAT.getBytes();
        }
        this.currentRowCharLens[n3] = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBinaryDouble(int n2, double d2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.setBinaryDoubleInternal(n2, d2);
        }
    }

    void setBinaryDoubleInternal(int n2, double d2) throws SQLException {
        int n3 = n2 - 1;
        if (n3 < 0 || n2 > this.numberOfBindPositions) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.currentRowBinders[n3] = this.theBinaryDoubleBinder;
        if (this.parameterDouble == null) {
            this.parameterDouble = new double[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
        }
        this.currentRowCharLens[n3] = 0;
        this.parameterDouble[this.currentRank][n3] = d2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBinaryDouble(int n2, BINARY_DOUBLE bINARY_DOUBLE) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.setBinaryDoubleInternal(n2, bINARY_DOUBLE);
        }
    }

    void setBinaryDoubleInternal(int n2, BINARY_DOUBLE bINARY_DOUBLE) throws SQLException {
        int n3 = n2 - 1;
        if (n3 < 0 || n2 > this.numberOfBindPositions) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (bINARY_DOUBLE == null) {
            this.currentRowBinders[n3] = this.theBINARY_DOUBLENullBinder;
        } else {
            this.currentRowBinders[n3] = this.theBINARY_DOUBLEBinder;
            if (this.parameterDatum == null) {
                this.parameterDatum = new byte[this.numberOfBindRowsAllocated][this.numberOfBindPositions][];
            }
            this.parameterDatum[this.currentRank][n3] = bINARY_DOUBLE.getBytes();
        }
        this.currentRowCharLens[n3] = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDouble(int n2, double d2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.setDoubleInternal(n2, d2);
        }
    }

    void setDoubleInternal(int n2, double d2) throws SQLException {
        int n3 = n2 - 1;
        if (n3 < 0 || n2 > this.numberOfBindPositions) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.theDoubleBinder == null) {
            this.theDoubleBinder = theStaticDoubleBinder;
            if (this.connection.setFloatAndDoubleUseBinary) {
                this.theDoubleBinder = theStaticBinaryDoubleBinder;
            }
        }
        this.currentRowCharLens[n3] = 0;
        this.currentRowBinders[n3] = this.theDoubleBinder;
        if (this.parameterDouble == null) {
            this.parameterDouble = new double[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
        }
        this.parameterDouble[this.currentRank][n3] = d2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBigDecimal(int n2, BigDecimal bigDecimal) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.setBigDecimalInternal(n2, bigDecimal);
        }
    }

    void setBigDecimalInternal(int n2, BigDecimal bigDecimal) throws SQLException {
        int n3 = n2 - 1;
        if (n3 < 0 || n2 > this.numberOfBindPositions) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (bigDecimal == null) {
            this.currentRowBinders[n3] = this.theVarnumNullBinder;
        } else {
            this.currentRowBinders[n3] = this.theBigDecimalBinder;
            if (this.parameterBigDecimal == null) {
                this.parameterBigDecimal = new BigDecimal[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
            }
            this.parameterBigDecimal[this.currentRank][n3] = bigDecimal;
        }
        this.currentRowCharLens[n3] = 0;
    }

    @Override
    public void setString(int n2, String string) throws SQLException {
        this.setStringInternal(n2, string);
    }

    void setStringInternal(int n2, String string) throws SQLException {
        int n3;
        int n4 = n2 - 1;
        if (n4 < 0 || n2 > this.numberOfBindPositions) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        int n5 = n3 = string != null ? string.length() : 0;
        if (n3 == 0) {
            this.basicBindNullString(n2);
        } else if (this.currentRowFormOfUse[n2 - 1] == 1) {
            if (this.sqlKind.isPlsqlOrCall()) {
                if (n3 > this.maxVcsBytesPlsql || n3 > this.maxVcsCharsPlsql && this.isServerCharSetFixedWidth) {
                    this.setStringForClobCritical(n2, string);
                } else if (n3 > this.maxVcsCharsPlsql) {
                    int n6 = this.connection.conversion.encodedByteLength(string, false);
                    if (n6 > this.maxVcsBytesPlsql) {
                        this.setStringForClobCritical(n2, string);
                    } else {
                        this.basicBindString(n2, string);
                    }
                } else {
                    this.basicBindString(n2, string);
                }
            } else if (n3 <= this.maxVcsCharsSql) {
                this.basicBindString(n2, string);
            } else if (n3 <= this.maxStreamCharsSql) {
                this.basicBindCharacterStream(n2, new StringReader(string), n3, true);
            } else {
                this.setStringForClobCritical(n2, string);
            }
        } else if (this.sqlKind.isPlsqlOrCall()) {
            if (n3 > this.maxVcsBytesPlsql || n3 > this.maxVcsNCharsPlsql && this.isServerNCharSetFixedWidth) {
                this.setStringForClobCritical(n2, string);
            } else if (n3 > this.maxVcsNCharsPlsql) {
                int n7 = this.connection.conversion.encodedByteLength(string, true);
                if (n7 > this.maxVcsBytesPlsql) {
                    this.setStringForClobCritical(n2, string);
                } else {
                    this.basicBindString(n2, string);
                }
            } else {
                this.basicBindString(n2, string);
            }
        } else if (n3 <= this.maxVcsCharsSql) {
            this.basicBindString(n2, string);
        } else if (n3 <= this.maxStreamNCharsSql) {
            this.setStringForClobCritical(n2, string);
        } else {
            this.setStringForClobCritical(n2, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void basicBindNullString(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            int n3 = n2 - 1;
            this.currentRowBinders[n3] = this.theVarcharNullBinder;
            this.currentRowCharLens[n3] = this.sqlKind.isPlsqlOrCall() ? this.minVcsBindSize : 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void basicBindString(int n2, String string) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            int n3;
            int n4;
            int n5 = n2 - 1;
            this.currentRowBinders[n5] = this.theStringBinder;
            int n6 = string.length();
            this.currentRowCharLens[n5] = this.sqlKind.isPlsqlOrCall() ? ((n4 = n6 + 1) < (n3 = this.connection.minVcsBindSize) ? n3 : n4) : n6 + 1;
            if (this.parameterString == null) {
                this.parameterString = new String[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
            }
            this.parameterString[this.currentRank][n5] = string;
        }
    }

    @Override
    public void setStringForClob(int n2, String string) throws SQLException {
        if (string == null) {
            this.setNull(n2, 1);
            return;
        }
        int n3 = string.length();
        if (n3 == 0) {
            this.setNull(n2, 1);
            return;
        }
        if (this.sqlKind.isPlsqlOrCall()) {
            if (n3 <= this.maxVcsCharsPlsql) {
                this.setStringInternal(n2, string);
            } else {
                this.setStringForClobCritical(n2, string);
            }
        } else if (n3 <= this.maxVcsCharsSql) {
            this.setStringInternal(n2, string);
        } else {
            this.setStringForClobCritical(n2, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setStringForClobCritical(int n2, String string) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            CLOB cLOB = CLOB.createTemporary(this.connection, true, 10, this.currentRowFormOfUse[n2 - 1]);
            cLOB.setString(1L, string);
            this.addToTempLobsToFree(cLOB);
            this.lastBoundClobs[n2 - 1] = cLOB;
            this.setCLOBInternal(n2, cLOB);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setReaderContentsForClobCritical(int n2, Reader reader, long l2, boolean bl) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                reader = this.isReaderEmpty(reader);
                if (reader == null) {
                    if (bl) {
                        throw new IOException(l2 + " char of CLOB data cannot be read");
                    }
                    this.setCLOBInternal(n2, null);
                    return;
                }
            }
            catch (IOException iOException) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            CLOB cLOB = CLOB.createTemporary(this.connection, true, 10, this.currentRowFormOfUse[n2 - 1]);
            OracleClobWriter oracleClobWriter = (OracleClobWriter)cLOB.setCharacterStream(1L);
            int n3 = cLOB.getBufferSize();
            char[] cArray = new char[n3];
            long l3 = 0L;
            int n4 = 0;
            try {
                for (l3 = bl ? l2 : Long.MAX_VALUE; l3 > 0L; l3 -= (long)n4) {
                    n4 = l3 >= (long)n3 ? reader.read(cArray) : reader.read(cArray, 0, (int)l3);
                    if (n4 == -1) {
                        if (!bl) break;
                        throw new IOException(l3 + " char of CLOB data cannot be read");
                    }
                    oracleClobWriter.write(cArray, 0, n4);
                }
                oracleClobWriter.flush();
            }
            catch (IOException iOException) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.addToTempLobsToFree(cLOB);
            this.lastBoundClobs[n2 - 1] = cLOB;
            this.setCLOBInternal(n2, cLOB);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setAsciiStreamContentsForClobCritical(int n2, InputStream inputStream, long l2, boolean bl) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                inputStream = this.isInputStreamEmpty(inputStream);
                if (inputStream == null) {
                    if (bl) {
                        throw new IOException(l2 + " byte of CLOB data cannot be read");
                    }
                    this.setCLOBInternal(n2, null);
                    return;
                }
            }
            catch (IOException iOException) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            CLOB cLOB = CLOB.createTemporary(this.connection, true, 10, this.currentRowFormOfUse[n2 - 1]);
            OracleClobWriter oracleClobWriter = (OracleClobWriter)cLOB.setCharacterStream(1L);
            int n3 = cLOB.getBufferSize();
            byte[] byArray = new byte[n3];
            char[] cArray = new char[n3];
            int n4 = 0;
            try {
                for (long i2 = bl ? l2 : Long.MAX_VALUE; i2 > 0L; i2 -= (long)n4) {
                    n4 = i2 >= (long)n3 ? inputStream.read(byArray) : inputStream.read(byArray, 0, (int)i2);
                    if (n4 == -1) {
                        if (!bl) break;
                        throw new IOException(i2 + " byte of CLOB data cannot be read");
                    }
                    DBConversion cfr_ignored_0 = this.connection.conversion;
                    DBConversion.asciiBytesToJavaChars(byArray, n4, cArray);
                    oracleClobWriter.write(cArray, 0, n4);
                }
                oracleClobWriter.flush();
            }
            catch (IOException iOException) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.addToTempLobsToFree(cLOB);
            this.lastBoundClobs[n2 - 1] = cLOB;
            this.setCLOBInternal(n2, cLOB);
        }
    }

    @Override
    public void setStringForClobAtName(String string, String string2) throws SQLException {
        String string3 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string3) continue;
            this.setStringForClob(i2 + 1, string2);
            bl = true;
        }
        if (!bl) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFixedCHAR(int n2, String string) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.setFixedCHARInternal(n2, string);
        }
    }

    void setFixedCHARInternal(int n2, String string) throws SQLException {
        int n3 = n2 - 1;
        if (n3 < 0 || n2 > this.numberOfBindPositions) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        int n4 = 0;
        if (string != null) {
            n4 = string.length();
        }
        if (n4 > 32766) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 157);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (string == null) {
            this.currentRowBinders[n3] = this.theFixedCHARNullBinder;
            this.currentRowCharLens[n3] = 1;
        } else {
            this.currentRowBinders[n3] = this.theFixedCHARBinder;
            this.currentRowCharLens[n3] = n4 + 1;
            if (this.parameterString == null) {
                this.parameterString = new String[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
            }
            this.parameterString[this.currentRank][n3] = string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCursor(int n2, ResultSet resultSet) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.setCursorInternal(n2, resultSet);
        }
    }

    void setCursorInternal(int n2, ResultSet resultSet) throws SQLException {
        SQLException sQLException = DatabaseError.createUnsupportedFeatureSqlException();
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setROWID(int n2, ROWID rOWID) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.setROWIDInternal(n2, rOWID);
        }
    }

    void setROWIDInternal(int n2, ROWID rOWID) throws SQLException {
        if (this.sqlKind == OracleStatement.SqlKind.CALL_BLOCK) {
            if (rOWID == null) {
                this.setNull(n2, 12);
            } else {
                this.setStringInternal(n2, rOWID.stringValue());
            }
            return;
        }
        int n3 = n2 - 1;
        if (n3 < 0 || n2 > this.numberOfBindPositions) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (rOWID == null || rOWID.shareBytes() == null) {
            this.currentRowBinders[n3] = this.theRowidNullBinder;
        } else {
            Binder binder = this.currentRowBinders[n3] = T4CRowidAccessor.isUROWID(rOWID.shareBytes(), 0) ? this.theURowidBinder : this.theRowidBinder;
            if (this.parameterDatum == null) {
                this.parameterDatum = new byte[this.numberOfBindRowsAllocated][this.numberOfBindPositions][];
            }
            this.parameterDatum[this.currentRank][n3] = rOWID.getBytes();
        }
        this.currentRowCharLens[n3] = 0;
    }

    @Override
    public void setArray(int n2, Array array) throws SQLException {
        this.setARRAYInternal(n2, (ARRAY)array);
    }

    void setArrayInternal(int n2, Array array) throws SQLException {
        this.setARRAYInternal(n2, (ARRAY)array);
    }

    @Override
    public void setARRAY(int n2, ARRAY aRRAY) throws SQLException {
        this.setARRAYInternal(n2, aRRAY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setARRAYInternal(int n2, ARRAY aRRAY) throws SQLException {
        int n3 = n2 - 1;
        if (n3 < 0 || n2 > this.numberOfBindPositions) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (aRRAY == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.setArrayCritical(n3, aRRAY);
            this.currentRowCharLens[n3] = 0;
        }
    }

    void setArrayCritical(int n2, ARRAY aRRAY) throws SQLException {
        ArrayDescriptor arrayDescriptor = aRRAY.getDescriptor();
        if (arrayDescriptor == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 61);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.currentRowBinders[n2] = this.theNamedTypeBinder;
        if (this.parameterDatum == null) {
            this.parameterDatum = new byte[this.numberOfBindRowsAllocated][this.numberOfBindPositions][];
        }
        this.parameterDatum[this.currentRank][n2] = aRRAY.toBytes();
        OracleTypeCOLLECTION oracleTypeCOLLECTION = arrayDescriptor.getOracleTypeCOLLECTION();
        oracleTypeCOLLECTION.getTOID();
        if (this.parameterOtype == null) {
            this.parameterOtype = new OracleTypeADT[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
        }
        this.parameterOtype[this.currentRank][n2] = oracleTypeCOLLECTION;
    }

    @Override
    public void setOPAQUE(int n2, OPAQUE oPAQUE) throws SQLException {
        this.setOPAQUEInternal(n2, oPAQUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setOPAQUEInternal(int n2, OPAQUE oPAQUE) throws SQLException {
        int n3 = n2 - 1;
        if (n3 < 0 || n2 > this.numberOfBindPositions) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (oPAQUE == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.setOPAQUECritical(n3, oPAQUE);
            this.currentRowCharLens[n3] = 0;
        }
    }

    void setOPAQUECritical(int n2, OPAQUE oPAQUE) throws SQLException {
        OpaqueDescriptor opaqueDescriptor = oPAQUE.getDescriptor();
        if (opaqueDescriptor == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 61);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.currentRowBinders[n2] = this.theNamedTypeBinder;
        if (this.parameterDatum == null) {
            this.parameterDatum = new byte[this.numberOfBindRowsAllocated][this.numberOfBindPositions][];
        }
        this.parameterDatum[this.currentRank][n2] = oPAQUE.toBytes();
        OracleTypeADT oracleTypeADT = (OracleTypeADT)opaqueDescriptor.getPickler();
        oracleTypeADT.getTOID();
        if (this.parameterOtype == null) {
            this.parameterOtype = new OracleTypeADT[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
        }
        this.parameterOtype[this.currentRank][n2] = oracleTypeADT;
    }

    void setSQLXMLInternal(int n2, SQLXML sQLXML) throws SQLException {
        if (sQLXML == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.setOPAQUEInternal(n2, (OPAQUE)((Object)sQLXML));
    }

    @Override
    public void setStructDescriptor(int n2, StructDescriptor structDescriptor) throws SQLException {
        this.setStructDescriptorInternal(n2, structDescriptor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setStructDescriptorInternal(int n2, StructDescriptor structDescriptor) throws SQLException {
        int n3 = n2 - 1;
        if (n3 < 0 || n2 > this.numberOfBindPositions) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (structDescriptor == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.setStructDescriptorCritical(n3, structDescriptor);
            this.currentRowCharLens[n3] = 0;
        }
    }

    void setStructDescriptorCritical(int n2, StructDescriptor structDescriptor) throws SQLException {
        this.currentRowBinders[n2] = this.theNamedTypeBinder;
        if (this.parameterDatum == null) {
            this.parameterDatum = new byte[this.numberOfBindRowsAllocated][this.numberOfBindPositions][];
        }
        OracleTypeADT oracleTypeADT = structDescriptor.getOracleTypeADT();
        oracleTypeADT.getTOID();
        if (this.parameterOtype == null) {
            this.parameterOtype = new OracleTypeADT[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
        }
        this.parameterOtype[this.currentRank][n2] = oracleTypeADT;
    }

    @Override
    public void setStructDescriptorAtName(String string, StructDescriptor structDescriptor) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setStructDescriptorInternal(i2 + 1, structDescriptor);
            bl = true;
        }
        if (!bl) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    void setPreBindsCompelete() throws SQLException {
    }

    @Override
    public void setSTRUCT(int n2, STRUCT sTRUCT) throws SQLException {
        this.setSTRUCTInternal(n2, sTRUCT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setSTRUCTInternal(int n2, STRUCT sTRUCT) throws SQLException {
        int n3 = n2 - 1;
        if (n3 < 0 || n2 > this.numberOfBindPositions) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (sTRUCT == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.setSTRUCTCritical(n3, sTRUCT);
            this.currentRowCharLens[n3] = 0;
        }
    }

    void setSTRUCTCritical(int n2, STRUCT sTRUCT) throws SQLException {
        StructDescriptor structDescriptor = sTRUCT.getDescriptor();
        if (structDescriptor == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 61);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.currentRowBinders[n2] = this.theNamedTypeBinder;
        if (this.parameterDatum == null) {
            this.parameterDatum = new byte[this.numberOfBindRowsAllocated][this.numberOfBindPositions][];
        }
        this.parameterDatum[this.currentRank][n2] = sTRUCT.toBytes();
        OracleTypeADT oracleTypeADT = structDescriptor.getOracleTypeADT();
        oracleTypeADT.getTOID();
        if (this.parameterOtype == null) {
            this.parameterOtype = new OracleTypeADT[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
        }
        this.parameterOtype[this.currentRank][n2] = oracleTypeADT;
    }

    @Override
    public void setRAW(int n2, RAW rAW) throws SQLException {
        this.setRAWInternal(n2, rAW);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setRAWInternal(int n2, RAW rAW) throws SQLException {
        boolean bl = false;
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            int n3 = n2 - 1;
            if (n3 < 0 || n2 > this.numberOfBindPositions) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.currentRowCharLens[n3] = 0;
            if (rAW == null) {
                this.currentRowBinders[n3] = this.theRawNullBinder;
            } else {
                bl = true;
            }
        }
        if (bl) {
            this.setBytesInternal(n2, rAW.getBytes());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCHAR(int n2, CHAR cHAR) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.setCHARInternal(n2, cHAR);
        }
    }

    void setCHARInternal(int n2, CHAR cHAR) throws SQLException {
        int n3 = n2 - 1;
        if (n3 < 0 || n2 > this.numberOfBindPositions) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (cHAR == null || cHAR.getLength() == 0L) {
            this.currentRowBinders[n3] = this.theSetCHARNullBinder;
            this.currentRowCharLens[n3] = 1;
        } else {
            byte[] byArray;
            CharacterSet characterSet;
            short s2 = (short)cHAR.oracleId();
            this.currentRowBinders[n3] = this.theSetCHARBinder;
            if (this.parameterDatum == null) {
                this.parameterDatum = new byte[this.numberOfBindRowsAllocated][this.numberOfBindPositions][];
            }
            CharacterSet characterSet2 = characterSet = this.currentRowFormOfUse[n3] == 2 ? this.connection.setCHARNCharSetObj : this.connection.setCHARCharSetObj;
            if (characterSet != null && characterSet.getOracleId() != s2) {
                byte[] byArray2 = cHAR.shareBytes();
                byArray = characterSet.convert(cHAR.getCharacterSet(), byArray2, 0, byArray2.length);
            } else {
                byArray = cHAR.getBytes();
            }
            this.parameterDatum[this.currentRank][n3] = byArray;
            this.currentRowCharLens[n3] = (byArray.length + 1 >> 1) + 1;
        }
        if (this.sqlKind.isPlsqlOrCall() && this.currentRowCharLens[n3] < this.minVcsBindSize) {
            this.currentRowCharLens[n3] = this.minVcsBindSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDATE(int n2, DATE dATE) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.setDATEInternal(n2, dATE);
        }
    }

    void setDATEInternal(int n2, DATE dATE) throws SQLException {
        int n3 = n2 - 1;
        if (n3 < 0 || n2 > this.numberOfBindPositions) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.currentRowCharLens[n3] = 0;
        if (dATE == null) {
            this.currentRowBinders[n3] = this.theDateNullBinder;
        } else {
            this.currentRowBinders[n3] = this.theOracleDateBinder;
            if (this.parameterDatum == null) {
                this.parameterDatum = new byte[this.numberOfBindRowsAllocated][this.numberOfBindPositions][];
            }
            this.parameterDatum[this.currentRank][n3] = dATE.getBytes();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNUMBER(int n2, NUMBER nUMBER) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.setNUMBERInternal(n2, nUMBER);
        }
    }

    void setNUMBERInternal(int n2, NUMBER nUMBER) throws SQLException {
        int n3 = n2 - 1;
        if (n3 < 0 || n2 > this.numberOfBindPositions) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.currentRowCharLens[n3] = 0;
        if (nUMBER == null) {
            this.currentRowBinders[n3] = this.theVarnumNullBinder;
        } else {
            this.currentRowBinders[n3] = this.theOracleNumberBinder;
            if (this.parameterDatum == null) {
                this.parameterDatum = new byte[this.numberOfBindRowsAllocated][this.numberOfBindPositions][];
            }
            this.parameterDatum[this.currentRank][n3] = nUMBER.getBytes();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBLOB(int n2, BLOB bLOB) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.setBLOBInternal(n2, bLOB);
        }
    }

    void setBLOBInternal(int n2, BLOB bLOB) throws SQLException {
        int n3 = n2 - 1;
        if (n3 < 0 || n2 > this.numberOfBindPositions) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.currentRowCharLens[n3] = 0;
        if (bLOB == null) {
            this.currentRowBinders[n3] = this.theBlobNullBinder;
        } else {
            this.currentRowBinders[n3] = this.theBlobBinder;
            if (this.parameterDatum == null) {
                this.parameterDatum = new byte[this.numberOfBindRowsAllocated][this.numberOfBindPositions][];
            }
            this.parameterDatum[this.currentRank][n3] = bLOB.getBytes();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBlob(int n2, Blob blob) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.setBLOBInternal(n2, (BLOB)blob);
        }
    }

    void setBlobInternal(int n2, Blob blob) throws SQLException {
        this.setBLOBInternal(n2, (BLOB)blob);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCLOB(int n2, CLOB cLOB) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.setCLOBInternal(n2, cLOB);
        }
    }

    void setCLOBInternal(int n2, CLOB cLOB) throws SQLException {
        int n3 = n2 - 1;
        if (n3 < 0 || n2 > this.numberOfBindPositions) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.currentRowCharLens[n3] = 0;
        if (cLOB == null) {
            this.currentRowBinders[n3] = this.theClobNullBinder;
        } else {
            this.currentRowBinders[n3] = this.theClobBinder;
            if (this.parameterDatum == null) {
                this.parameterDatum = new byte[this.numberOfBindRowsAllocated][this.numberOfBindPositions][];
            }
            this.parameterDatum[this.currentRank][n3] = cLOB.getBytes();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setClob(int n2, Clob clob) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.setCLOBInternal(n2, (CLOB)clob);
        }
    }

    void setClobInternal(int n2, Clob clob) throws SQLException {
        this.setCLOBInternal(n2, (CLOB)clob);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBFILE(int n2, BFILE bFILE) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.setBFILEInternal(n2, bFILE);
        }
    }

    void setBFILEInternal(int n2, BFILE bFILE) throws SQLException {
        int n3 = n2 - 1;
        if (n3 < 0 || n2 > this.numberOfBindPositions) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.currentRowCharLens[n3] = 0;
        if (bFILE == null) {
            this.currentRowBinders[n3] = this.theBfileNullBinder;
        } else {
            this.currentRowBinders[n3] = this.theBfileBinder;
            if (this.parameterDatum == null) {
                this.parameterDatum = new byte[this.numberOfBindRowsAllocated][this.numberOfBindPositions][];
            }
            this.parameterDatum[this.currentRank][n3] = bFILE.getBytes();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBfile(int n2, BFILE bFILE) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.setBFILEInternal(n2, bFILE);
        }
    }

    void setBfileInternal(int n2, BFILE bFILE) throws SQLException {
        this.setBFILEInternal(n2, bFILE);
    }

    @Override
    public void setBytes(int n2, byte[] byArray) throws SQLException {
        this.setBytesInternal(n2, byArray);
    }

    void setBytesInternal(int n2, byte[] byArray) throws SQLException {
        int n3;
        int n4 = n2 - 1;
        if (n4 < 0 || n2 > this.numberOfBindPositions) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        int n5 = n3 = byArray != null ? byArray.length : 0;
        if (n3 == 0) {
            this.setNullInternal(n2, -2);
        } else if (this.sqlKind == OracleStatement.SqlKind.PLSQL_BLOCK) {
            if (n3 > this.maxRawBytesPlsql) {
                this.setBytesForBlobCritical(n2, byArray);
            } else {
                this.basicBindBytes(n2, byArray);
            }
        } else if (this.sqlKind == OracleStatement.SqlKind.CALL_BLOCK) {
            if (n3 > this.maxRawBytesPlsql) {
                this.setBytesForBlobCritical(n2, byArray);
            } else {
                this.basicBindBytes(n2, byArray);
            }
        } else if (n3 > this.maxRawBytesSql) {
            this.bindBytesAsStream(n2, byArray);
        } else {
            this.basicBindBytes(n2, byArray);
        }
    }

    void bindBytesAsStream(int n2, byte[] byArray) throws SQLException {
        int n3 = byArray.length;
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, 0, byArray2, 0, n3);
        this.set_execute_batch(1);
        this.basicBindBinaryStream(n2, new ByteArrayInputStream(byArray2), n3, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void basicBindBytes(int n2, byte[] byArray) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Binder binder;
            int n3 = n2 - 1;
            this.currentRowBinders[n3] = binder = this.sqlKind.isPlsqlOrCall() ? this.thePlsqlRawBinder : this.theRawBinder;
            if (this.parameterDatum == null) {
                this.parameterDatum = new byte[this.numberOfBindRowsAllocated][this.numberOfBindPositions][];
            }
            this.parameterDatum[this.currentRank][n3] = byArray;
            this.currentRowCharLens[n3] = 0;
        }
    }

    void basicBindBinaryStream(int n2, InputStream inputStream, int n3) throws SQLException {
        this.basicBindBinaryStream(n2, inputStream, n3, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void basicBindBinaryStream(int n2, InputStream inputStream, int n3, boolean bl) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            int n4 = n2 - 1;
            this.currentRowBinders[n4] = bl ? this.theLongRawStreamForBytesBinder : this.theLongRawStreamBinder;
            if (this.parameterStream == null) {
                this.parameterStream = new InputStream[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
            }
            this.parameterStream[this.currentRank][n4] = bl ? this.connection.conversion.ConvertStreamInternal(inputStream, 6, n3) : this.connection.conversion.ConvertStream(inputStream, 6, n3);
            this.currentRowCharLens[n4] = 0;
        }
    }

    @Override
    public void setBytesForBlob(int n2, byte[] byArray) throws SQLException {
        if (byArray == null) {
            this.setNull(n2, -2);
            return;
        }
        int n3 = byArray.length;
        if (n3 == 0) {
            this.setNull(n2, -2);
            return;
        }
        if (this.sqlKind.isPlsqlOrCall()) {
            if (n3 <= this.maxRawBytesPlsql) {
                this.setBytes(n2, byArray);
            } else {
                this.setBytesForBlobCritical(n2, byArray);
            }
        } else if (n3 <= this.maxRawBytesSql) {
            this.setBytes(n2, byArray);
        } else {
            this.setBytesForBlobCritical(n2, byArray);
        }
    }

    void setBytesForBlobCritical(int n2, byte[] byArray) throws SQLException {
        BLOB bLOB = BLOB.createTemporary(this.connection, true, 10);
        bLOB.putBytes(1L, byArray);
        this.addToTempLobsToFree(bLOB);
        this.lastBoundBlobs[n2 - 1] = bLOB;
        this.setBLOBInternal(n2, bLOB);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setBinaryStreamContentsForBlobCritical(int n2, InputStream inputStream, long l2, boolean bl) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                inputStream = this.isInputStreamEmpty(inputStream);
                if (inputStream == null) {
                    if (bl) {
                        throw new IOException(l2 + " byte of BLOB data cannot be read");
                    }
                    this.setBLOBInternal(n2, null);
                    return;
                }
            }
            catch (IOException iOException) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            BLOB bLOB = BLOB.createTemporary(this.connection, true, 10);
            OracleBlobOutputStream oracleBlobOutputStream = (OracleBlobOutputStream)bLOB.setBinaryStream(1L);
            int n3 = bLOB.getBufferSize();
            byte[] byArray = new byte[n3];
            long l3 = 0L;
            int n4 = 0;
            try {
                for (l3 = bl ? l2 : Long.MAX_VALUE; l3 > 0L; l3 -= (long)n4) {
                    n4 = l3 >= (long)n3 ? inputStream.read(byArray) : inputStream.read(byArray, 0, (int)l3);
                    if (n4 == -1) {
                        if (!bl) break;
                        throw new IOException(l3 + " byte of BLOB data cannot be read");
                    }
                    oracleBlobOutputStream.write(byArray, 0, n4);
                }
                oracleBlobOutputStream.flush();
            }
            catch (IOException iOException) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.addToTempLobsToFree(bLOB);
            this.lastBoundBlobs[n2 - 1] = bLOB;
            this.setBLOBInternal(n2, bLOB);
        }
    }

    @Override
    public void setBytesForBlobAtName(String string, byte[] byArray) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setBytesForBlob(i2 + 1, byArray);
            bl = true;
        }
        if (!bl) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setInternalBytes(int n2, byte[] byArray, int n3) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.setInternalBytesInternal(n2, byArray, n3);
        }
    }

    void setInternalBytesInternal(int n2, byte[] byArray, int n3) throws SQLException {
        SQLException sQLException = DatabaseError.createUnsupportedFeatureSqlException();
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDate(int n2, Date date) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.setDATEInternal(n2, date == null ? null : new DATE(date, this.getDefaultCalendar()));
        }
    }

    void setDateInternal(int n2, Date date) throws SQLException {
        this.setDATEInternal(n2, date == null ? null : new DATE(date, this.getDefaultCalendar()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTime(int n2, Time time) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.setTimeInternal(n2, time);
        }
    }

    void setTimeInternal(int n2, Time time) throws SQLException {
        int n3 = n2 - 1;
        if (n3 < 0 || n2 > this.numberOfBindPositions) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (time == null) {
            this.currentRowBinders[n3] = this.theDateNullBinder;
        } else {
            this.currentRowBinders[n3] = this.theTimeBinder;
            if (this.parameterTime == null) {
                this.parameterTime = new Time[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
            }
            this.parameterTime[this.currentRank][n3] = time;
        }
        this.currentRowCharLens[n3] = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTimestamp(int n2, Timestamp timestamp) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.setTimestampInternal(n2, timestamp);
        }
    }

    void setTimestampInternal(int n2, Timestamp timestamp) throws SQLException {
        int n3 = n2 - 1;
        if (n3 < 0 || n2 > this.numberOfBindPositions) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (timestamp == null) {
            this.currentRowBinders[n3] = this.theTimestampNullBinder;
        } else {
            this.currentRowBinders[n3] = this.theTimestampBinder;
            if (this.parameterTimestamp == null) {
                this.parameterTimestamp = new Timestamp[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
            }
            this.parameterTimestamp[this.currentRank][n3] = timestamp;
        }
        this.currentRowCharLens[n3] = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setINTERVALYM(int n2, INTERVALYM iNTERVALYM) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.setINTERVALYMInternal(n2, iNTERVALYM);
        }
    }

    void setINTERVALYMInternal(int n2, INTERVALYM iNTERVALYM) throws SQLException {
        int n3 = n2 - 1;
        if (n3 < 0 || n2 > this.numberOfBindPositions) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (iNTERVALYM == null) {
            this.currentRowBinders[n3] = this.theIntervalYMNullBinder;
        } else {
            this.currentRowBinders[n3] = this.theIntervalYMBinder;
            if (this.parameterDatum == null) {
                this.parameterDatum = new byte[this.numberOfBindRowsAllocated][this.numberOfBindPositions][];
            }
            this.parameterDatum[this.currentRank][n3] = iNTERVALYM.getBytes();
        }
        this.currentRowCharLens[n3] = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setINTERVALDS(int n2, INTERVALDS iNTERVALDS) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.setINTERVALDSInternal(n2, iNTERVALDS);
        }
    }

    void setINTERVALDSInternal(int n2, INTERVALDS iNTERVALDS) throws SQLException {
        int n3 = n2 - 1;
        if (n3 < 0 || n2 > this.numberOfBindPositions) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (iNTERVALDS == null) {
            this.currentRowBinders[n3] = this.theIntervalDSNullBinder;
        } else {
            this.currentRowBinders[n3] = this.theIntervalDSBinder;
            if (this.parameterDatum == null) {
                this.parameterDatum = new byte[this.numberOfBindRowsAllocated][this.numberOfBindPositions][];
            }
            this.parameterDatum[this.currentRank][n3] = iNTERVALDS.getBytes();
        }
        this.currentRowCharLens[n3] = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTIMESTAMP(int n2, TIMESTAMP tIMESTAMP) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.setTIMESTAMPInternal(n2, tIMESTAMP);
        }
    }

    void setTIMESTAMPInternal(int n2, TIMESTAMP tIMESTAMP) throws SQLException {
        int n3 = n2 - 1;
        if (n3 < 0 || n2 > this.numberOfBindPositions) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (tIMESTAMP == null) {
            this.currentRowBinders[n3] = this.theTimestampNullBinder;
        } else {
            this.currentRowBinders[n3] = this.theOracleTimestampBinder;
            if (this.parameterDatum == null) {
                this.parameterDatum = new byte[this.numberOfBindRowsAllocated][this.numberOfBindPositions][];
            }
            this.parameterDatum[this.currentRank][n3] = tIMESTAMP.getBytes();
        }
        this.currentRowCharLens[n3] = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTIMESTAMPTZ(int n2, TIMESTAMPTZ tIMESTAMPTZ) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.setTIMESTAMPTZInternal(n2, tIMESTAMPTZ);
        }
    }

    void setTIMESTAMPTZInternal(int n2, TIMESTAMPTZ tIMESTAMPTZ) throws SQLException {
        int n3 = n2 - 1;
        if (n3 < 0 || n2 > this.numberOfBindPositions) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (tIMESTAMPTZ == null) {
            this.currentRowBinders[n3] = this.theTSTZNullBinder;
        } else {
            this.currentRowBinders[n3] = this.theTSTZBinder;
            if (this.parameterDatum == null) {
                this.parameterDatum = new byte[this.numberOfBindRowsAllocated][this.numberOfBindPositions][];
            }
            this.parameterDatum[this.currentRank][n3] = tIMESTAMPTZ.getBytes();
        }
        this.currentRowCharLens[n3] = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTIMESTAMPLTZ(int n2, TIMESTAMPLTZ tIMESTAMPLTZ) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.setTIMESTAMPLTZInternal(n2, tIMESTAMPLTZ);
        }
    }

    void setTIMESTAMPLTZInternal(int n2, TIMESTAMPLTZ tIMESTAMPLTZ) throws SQLException {
        if (this.connection.getSessionTimeZone() == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 105);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        int n3 = n2 - 1;
        if (n3 < 0 || n2 > this.numberOfBindPositions) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (tIMESTAMPLTZ == null) {
            this.currentRowBinders[n3] = this.theTSLTZNullBinder;
        } else {
            this.currentRowBinders[n3] = this.theTSLTZBinder;
            if (this.parameterDatum == null) {
                this.parameterDatum = new byte[this.numberOfBindRowsAllocated][this.numberOfBindPositions][];
            }
            this.parameterDatum[this.currentRank][n3] = tIMESTAMPLTZ.getBytes();
        }
        this.currentRowCharLens[n3] = 0;
    }

    private Reader isReaderEmpty(Reader reader) throws IOException {
        if (!reader.markSupported()) {
            reader = new BufferedReader(reader, 5);
        }
        reader.mark(100);
        int n2 = reader.read();
        if (n2 == -1) {
            return null;
        }
        reader.reset();
        return reader;
    }

    private InputStream isInputStreamEmpty(InputStream inputStream) throws IOException {
        if (!inputStream.markSupported()) {
            inputStream = new BufferedInputStream(inputStream, 5);
        }
        inputStream.mark(100);
        int n2 = inputStream.read();
        if (n2 == -1) {
            return null;
        }
        inputStream.reset();
        return inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAsciiStream(int n2, InputStream inputStream, int n3) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.setAsciiStreamInternal(n2, inputStream, n3);
        }
    }

    void setAsciiStreamInternal(int n2, InputStream inputStream, int n3) throws SQLException {
        this.setAsciiStreamInternal(n2, inputStream, n3, true);
    }

    void setAsciiStreamInternal(int n2, InputStream inputStream, long l2, boolean bl) throws SQLException {
        int n3 = n2 - 1;
        if (n3 < 0 || n2 > this.numberOfBindPositions) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.set_execute_batch(1);
        this.checkUserStreamForDuplicates(inputStream, n3);
        if (inputStream == null) {
            this.basicBindNullString(n2);
        } else {
            if (!(this.userRsetType == 1 || l2 <= (long)this.maxVcsCharsSql && bl)) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 169);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (!bl) {
                this.setAsciiStreamContentsForClobCritical(n2, inputStream, l2, bl);
            } else if (this.currentRowFormOfUse[n3] == 1) {
                if (this.sqlKind.isPlsqlOrCall()) {
                    if (l2 <= (long)this.maxVcsCharsPlsql) {
                        this.setAsciiStreamContentsForStringInternal(n2, inputStream, (int)l2);
                    } else {
                        this.setAsciiStreamContentsForClobCritical(n2, inputStream, l2, bl);
                    }
                } else if (l2 <= (long)this.maxVcsCharsSql) {
                    this.setAsciiStreamContentsForStringInternal(n2, inputStream, (int)l2);
                } else if (l2 > Integer.MAX_VALUE) {
                    this.setAsciiStreamContentsForClobCritical(n2, inputStream, l2, bl);
                } else {
                    this.basicBindAsciiStream(n2, inputStream, (int)l2);
                }
            } else if (this.sqlKind.isPlsqlOrCall()) {
                if (l2 <= (long)this.maxVcsNCharsPlsql) {
                    this.setAsciiStreamContentsForStringInternal(n2, inputStream, (int)l2);
                } else {
                    this.setAsciiStreamContentsForClobCritical(n2, inputStream, l2, bl);
                }
            } else if (l2 <= (long)this.maxVcsNCharsSql) {
                this.setAsciiStreamContentsForStringInternal(n2, inputStream, (int)l2);
            } else {
                this.setAsciiStreamContentsForClobCritical(n2, inputStream, l2, bl);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void basicBindAsciiStream(int n2, InputStream inputStream, int n3) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.userRsetType != 1) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 169);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            int n4 = n2 - 1;
            this.currentRowBinders[n4] = this.theLongStreamBinder;
            if (this.parameterStream == null) {
                this.parameterStream = new InputStream[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
            }
            this.parameterStream[this.currentRank][n4] = this.connection.conversion.ConvertStream(inputStream, 5, n3);
            this.currentRowCharLens[n4] = 0;
        }
    }

    void setAsciiStreamContentsForStringInternal(int n2, InputStream inputStream, int n3) throws SQLException {
        byte[] byArray = new byte[n3];
        int n4 = 0;
        try {
            int n5;
            for (int i2 = n3; i2 > 0 && (n5 = inputStream.read(byArray, n4, i2)) != -1; i2 -= n5) {
                n4 += n5;
            }
        }
        catch (IOException iOException) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (n4 == 0) {
            this.basicBindNullString(n2);
        }
        char[] cArray = new char[n3];
        DBConversion cfr_ignored_0 = this.connection.conversion;
        DBConversion.asciiBytesToJavaChars(byArray, n4, cArray);
        this.basicBindString(n2, new String(cArray));
    }

    @Override
    public void setBinaryStream(int n2, InputStream inputStream, int n3) throws SQLException {
        this.setBinaryStreamInternal(n2, inputStream, n3);
    }

    void setBinaryStreamInternal(int n2, InputStream inputStream, int n3) throws SQLException {
        this.setBinaryStreamInternal(n2, inputStream, n3, true);
    }

    void checkUserStreamForDuplicates(Object object, int n2) throws SQLException {
        if (object == null) {
            return;
        }
        if (this.userStream != null) {
            Object[][] objectArray = this.userStream;
            int n3 = objectArray.length;
            for (int i2 = 0; i2 < n3; ++i2) {
                Object[] objectArray2;
                for (Object object2 : objectArray2 = objectArray[i2]) {
                    if (object2 != object) continue;
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 270, (Object)(n2 + 1));
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
            }
        } else {
            this.userStream = new Object[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
        }
        this.userStream[this.currentRank][n2] = object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setBinaryStreamInternal(int n2, InputStream inputStream, long l2, boolean bl) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            int n3 = n2 - 1;
            if (n3 < 0 || n2 > this.numberOfBindPositions) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.set_execute_batch(1);
            this.checkUserStreamForDuplicates(inputStream, n3);
            if (inputStream == null) {
                this.setRAWInternal(n2, null);
            } else {
                if (!(this.userRsetType == 1 || l2 <= (long)this.maxRawBytesSql && bl)) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 169);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                if (!bl) {
                    this.setBinaryStreamContentsForBlobCritical(n2, inputStream, l2, bl);
                } else if (this.sqlKind.isPlsqlOrCall()) {
                    if (l2 > (long)this.maxRawBytesPlsql) {
                        this.setBinaryStreamContentsForBlobCritical(n2, inputStream, l2, bl);
                    } else {
                        this.setBinaryStreamContentsForByteArrayInternal(n2, inputStream, (int)l2);
                    }
                } else if (l2 > Integer.MAX_VALUE) {
                    this.setBinaryStreamContentsForBlobCritical(n2, inputStream, l2, bl);
                } else if (l2 > (long)this.maxRawBytesSql) {
                    this.basicBindBinaryStream(n2, inputStream, (int)l2);
                } else {
                    this.setBinaryStreamContentsForByteArrayInternal(n2, inputStream, (int)l2);
                }
            }
        }
    }

    void setBinaryStreamContentsForByteArrayInternal(int n2, InputStream inputStream, int n3) throws SQLException {
        byte[] byArray = new byte[n3];
        int n4 = 0;
        try {
            int n5;
            for (int i2 = n3; i2 > 0 && (n5 = inputStream.read(byArray, n4, i2)) != -1; i2 -= n5) {
                n4 += n5;
            }
        }
        catch (IOException iOException) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (n4 != n3) {
            byte[] byArray2 = new byte[n4];
            System.arraycopy(byArray, 0, byArray2, 0, n4);
            byArray = byArray2;
        }
        this.setBytesInternal(n2, byArray);
    }

    @Override
    public void setUnicodeStream(int n2, InputStream inputStream, int n3) throws SQLException {
        this.setUnicodeStreamInternal(n2, inputStream, n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setUnicodeStreamInternal(int n2, InputStream inputStream, int n3) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            int n4 = n2 - 1;
            if (n4 < 0 || n2 > this.numberOfBindPositions) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.set_execute_batch(1);
            this.checkUserStreamForDuplicates(inputStream, n4);
            if (inputStream == null) {
                this.setStringInternal(n2, null);
            } else {
                if (this.userRsetType != 1 && n3 > this.maxVcsCharsSql) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 169);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                if (this.sqlKind.isPlsqlOrCall() || n3 <= this.maxVcsCharsSql) {
                    byte[] byArray = new byte[n3];
                    int n5 = 0;
                    try {
                        int n6;
                        for (int i2 = n3; i2 > 0 && (n6 = inputStream.read(byArray, n5, i2)) != -1; i2 -= n6) {
                            n5 += n6;
                        }
                    }
                    catch (IOException iOException) {
                        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
                        sQLException.fillInStackTrace();
                        throw sQLException;
                    }
                    char[] cArray = new char[n5 >> 1];
                    DBConversion cfr_ignored_0 = this.connection.conversion;
                    DBConversion.ucs2BytesToJavaChars(byArray, n5, cArray);
                    this.setStringInternal(n2, new String(cArray));
                } else {
                    this.currentRowBinders[n4] = this.theLongStreamBinder;
                    if (this.parameterStream == null) {
                        this.parameterStream = new InputStream[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
                    }
                    this.parameterStream[this.currentRank][n4] = this.connection.conversion.ConvertStream(inputStream, 4, n3);
                    this.currentRowCharLens[n4] = 0;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCustomDatum(int n2, CustomDatum customDatum) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.setObjectInternal(n2, this.connection.toDatum(customDatum));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setCustomDatumInternal(int n2, CustomDatum customDatum) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.connection.toDatum(customDatum);
            int n3 = this.sqlTypeForObject(datum);
            this.setObjectCritical(n2, datum, n3, 0);
        }
    }

    @Override
    public void setORAData(int n2, ORAData oRAData) throws SQLException {
        this.setORADataInternal(n2, oRAData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setORADataInternal(int n2, ORAData oRAData) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = oRAData.toDatum(this.connection);
            int n3 = this.sqlTypeForObject(datum);
            this.setObjectCritical(n2, datum, n3, 0);
            if (n3 == 2002 || n3 == 2008 || n3 == 2003) {
                this.currentRowCharLens[n2 - 1] = 0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setObject(int n2, Object object, int n3, int n4) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.setObjectInternal(n2, object, n3, n4);
        }
    }

    void setObjectInternal(int n2, Object object, int n3, int n4) throws SQLException {
        if (object == null && n3 != 2002 && n3 != 2008 && n3 != 2003 && n3 != 2007 && n3 != 2006 && n3 != 2009) {
            this.setNullInternal(n2, n3);
        } else if (n3 == 2002 || n3 == 2008 || n3 == 2003 || n3 == 2009) {
            this.setObjectCritical(n2, object, n3, n4);
            this.currentRowCharLens[n2 - 1] = 0;
        } else {
            this.setObjectCritical(n2, object, n3, n4);
        }
    }

    void setObjectCritical(int n2, Object object, int n3, int n4) throws SQLException {
        switch (n3) {
            case -15: {
                this.setFormOfUse(n2, (short)2);
            }
            case 1: {
                if (object instanceof CHAR) {
                    this.setCHARInternal(n2, (CHAR)object);
                    break;
                }
                if (object instanceof String) {
                    this.setStringInternal(n2, (String)object);
                    break;
                }
                if (object instanceof Boolean) {
                    this.setStringInternal(n2, "" + ((Boolean)object != false ? 1 : 0));
                    break;
                }
                if (object instanceof Integer) {
                    this.setStringInternal(n2, "" + (Integer)object);
                    break;
                }
                if (object instanceof Long) {
                    this.setStringInternal(n2, "" + (Long)object);
                    break;
                }
                if (object instanceof Float) {
                    this.setStringInternal(n2, "" + ((Float)object).floatValue());
                    break;
                }
                if (object instanceof Double) {
                    this.setStringInternal(n2, "" + (Double)object);
                    break;
                }
                if (object instanceof BigDecimal) {
                    this.setStringInternal(n2, ((BigDecimal)object).toString());
                    break;
                }
                if (object instanceof Date) {
                    this.setStringInternal(n2, "" + ((Date)object).toString());
                    break;
                }
                if (object instanceof Time) {
                    this.setStringInternal(n2, "" + ((Time)object).toString());
                    break;
                }
                if (object instanceof Timestamp) {
                    this.setStringInternal(n2, "" + ((Timestamp)object).toString());
                    break;
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 132);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            case -9: {
                this.setFormOfUse(n2, (short)2);
            }
            case 12: {
                if (object instanceof String) {
                    this.setStringInternal(n2, (String)object);
                    break;
                }
                if (object instanceof Boolean) {
                    this.setStringInternal(n2, "" + ((Boolean)object != false ? 1 : 0));
                    break;
                }
                if (object instanceof Integer) {
                    this.setStringInternal(n2, "" + (Integer)object);
                    break;
                }
                if (object instanceof Long) {
                    this.setStringInternal(n2, "" + (Long)object);
                    break;
                }
                if (object instanceof Float) {
                    this.setStringInternal(n2, "" + ((Float)object).floatValue());
                    break;
                }
                if (object instanceof Double) {
                    this.setStringInternal(n2, "" + (Double)object);
                    break;
                }
                if (object instanceof BigDecimal) {
                    this.setStringInternal(n2, ((BigDecimal)object).toString());
                    break;
                }
                if (object instanceof Date) {
                    this.setStringInternal(n2, "" + ((Date)object).toString());
                    break;
                }
                if (object instanceof Time) {
                    this.setStringInternal(n2, "" + ((Time)object).toString());
                    break;
                }
                if (object instanceof Timestamp) {
                    this.setStringInternal(n2, "" + ((Timestamp)object).toString());
                    break;
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 132);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            case 999: {
                this.setFixedCHARInternal(n2, (String)object);
                break;
            }
            case -16: {
                this.setFormOfUse(n2, (short)2);
            }
            case -1: {
                if (object instanceof String) {
                    this.setStringInternal(n2, (String)object);
                    break;
                }
                if (object instanceof Boolean) {
                    this.setStringInternal(n2, "" + ((Boolean)object != false ? 1 : 0));
                    break;
                }
                if (object instanceof Integer) {
                    this.setStringInternal(n2, "" + (Integer)object);
                    break;
                }
                if (object instanceof Long) {
                    this.setStringInternal(n2, "" + (Long)object);
                    break;
                }
                if (object instanceof Float) {
                    this.setStringInternal(n2, "" + ((Float)object).floatValue());
                    break;
                }
                if (object instanceof Double) {
                    this.setStringInternal(n2, "" + (Double)object);
                    break;
                }
                if (object instanceof BigDecimal) {
                    this.setStringInternal(n2, ((BigDecimal)object).toString());
                    break;
                }
                if (object instanceof Date) {
                    this.setStringInternal(n2, "" + ((Date)object).toString());
                    break;
                }
                if (object instanceof Time) {
                    this.setStringInternal(n2, "" + ((Time)object).toString());
                    break;
                }
                if (object instanceof Timestamp) {
                    this.setStringInternal(n2, "" + ((Timestamp)object).toString());
                    break;
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 132);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            case 2: {
                if (object instanceof NUMBER) {
                    this.setNUMBERInternal(n2, (NUMBER)object);
                    break;
                }
                if (object instanceof Integer) {
                    this.setIntInternal(n2, (Integer)object);
                    break;
                }
                if (object instanceof Long) {
                    this.setLongInternal(n2, (Long)object);
                    break;
                }
                if (object instanceof Float) {
                    this.setFloatInternal(n2, ((Float)object).floatValue());
                    break;
                }
                if (object instanceof Double) {
                    this.setDoubleInternal(n2, (Double)object);
                    break;
                }
                if (object instanceof BigDecimal) {
                    this.setBigDecimalInternal(n2, (BigDecimal)object);
                    break;
                }
                if (object instanceof String) {
                    this.setNUMBERInternal(n2, new NUMBER((String)object, n4));
                    break;
                }
                if (object instanceof Boolean) {
                    this.setIntInternal(n2, (Boolean)object != false ? 1 : 0);
                    break;
                }
                if (object instanceof Short) {
                    this.setShortInternal(n2, (Short)object);
                    break;
                }
                if (object instanceof Byte) {
                    this.setByteInternal(n2, (Byte)object);
                    break;
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 132);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            case 3: {
                if (object instanceof BigDecimal) {
                    this.setBigDecimalInternal(n2, (BigDecimal)object);
                    break;
                }
                if (object instanceof Number) {
                    this.setBigDecimalInternal(n2, new BigDecimal(((Number)object).doubleValue()));
                    break;
                }
                if (object instanceof NUMBER) {
                    this.setBigDecimalInternal(n2, ((NUMBER)object).bigDecimalValue());
                    break;
                }
                if (object instanceof String) {
                    this.setBigDecimalInternal(n2, new BigDecimal((String)object));
                    break;
                }
                if (object instanceof Boolean) {
                    this.setBigDecimalInternal(n2, new BigDecimal((Boolean)object != false ? 1.0 : 0.0));
                    break;
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 132);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            case -7: {
                if (object instanceof Boolean) {
                    this.setByteInternal(n2, (byte)((Boolean)object != false ? 1 : 0));
                    break;
                }
                if (object instanceof String) {
                    this.setByteInternal(n2, (byte)("true".equalsIgnoreCase((String)object) || "1".equals(object) ? 1 : 0));
                    break;
                }
                if (object instanceof Number) {
                    this.setIntInternal(n2, ((Number)object).byteValue() != 0 ? 1 : 0);
                    break;
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 132);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            case -6: {
                if (object instanceof Number) {
                    this.setByteInternal(n2, ((Number)object).byteValue());
                    break;
                }
                if (object instanceof String) {
                    this.setByteInternal(n2, Byte.parseByte((String)object));
                    break;
                }
                if (object instanceof Boolean) {
                    this.setByteInternal(n2, (byte)((Boolean)object != false ? 1 : 0));
                    break;
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 132);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            case 5: {
                if (object instanceof Number) {
                    this.setShortInternal(n2, ((Number)object).shortValue());
                    break;
                }
                if (object instanceof String) {
                    this.setShortInternal(n2, Short.parseShort((String)object));
                    break;
                }
                if (object instanceof Boolean) {
                    this.setShortInternal(n2, (short)((Boolean)object != false ? 1 : 0));
                    break;
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 132);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            case 4: {
                if (object instanceof Number) {
                    this.setIntInternal(n2, ((Number)object).intValue());
                    break;
                }
                if (object instanceof String) {
                    this.setIntInternal(n2, Integer.parseInt((String)object));
                    break;
                }
                if (object instanceof Boolean) {
                    this.setIntInternal(n2, (Boolean)object != false ? 1 : 0);
                    break;
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 132);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            case -5: {
                if (object instanceof Number) {
                    this.setLongInternal(n2, ((Number)object).longValue());
                    break;
                }
                if (object instanceof String) {
                    this.setLongInternal(n2, Long.parseLong((String)object));
                    break;
                }
                if (object instanceof Boolean) {
                    this.setLongInternal(n2, (Boolean)object != false ? 1L : 0L);
                    break;
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 132);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            case 7: {
                if (object instanceof Number) {
                    this.setFloatInternal(n2, ((Number)object).floatValue());
                    break;
                }
                if (object instanceof String) {
                    this.setFloatInternal(n2, Float.valueOf((String)object).floatValue());
                    break;
                }
                if (object instanceof Boolean) {
                    this.setFloatInternal(n2, (Boolean)object != false ? 1.0f : 0.0f);
                    break;
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 132);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            case 6: 
            case 8: {
                if (object instanceof Number) {
                    this.setDoubleInternal(n2, ((Number)object).doubleValue());
                    break;
                }
                if (object instanceof String) {
                    this.setDoubleInternal(n2, Double.valueOf((String)object));
                    break;
                }
                if (object instanceof Boolean) {
                    this.setDoubleInternal(n2, (Boolean)object != false ? 1.0 : 0.0);
                    break;
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 132);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            case -2: {
                if (object instanceof RAW) {
                    this.setRAWInternal(n2, (RAW)object);
                    break;
                }
                this.setBytesInternal(n2, (byte[])object);
                break;
            }
            case -3: {
                this.setBytesInternal(n2, (byte[])object);
                break;
            }
            case -4: {
                this.setBytesInternal(n2, (byte[])object);
                break;
            }
            case 91: {
                if (object instanceof DATE) {
                    this.setDATEInternal(n2, (DATE)object);
                    break;
                }
                if (object instanceof Date) {
                    this.setDATEInternal(n2, new DATE(object, this.getDefaultCalendar()));
                    break;
                }
                if (object instanceof Timestamp) {
                    this.setDATEInternal(n2, new DATE((Timestamp)object));
                    break;
                }
                if (object instanceof String) {
                    this.setDateInternal(n2, Date.valueOf((String)object));
                    break;
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 132);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            case 92: {
                if (object instanceof Time) {
                    this.setTimeInternal(n2, (Time)object);
                    break;
                }
                if (object instanceof Timestamp) {
                    this.setTimeInternal(n2, new Time(((Timestamp)object).getTime()));
                    break;
                }
                if (object instanceof Date) {
                    this.setTimeInternal(n2, new Time(((Date)object).getTime()));
                    break;
                }
                if (object instanceof String) {
                    this.setTimeInternal(n2, Time.valueOf((String)object));
                    break;
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 132);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            case 93: {
                if (object instanceof TIMESTAMP) {
                    this.setTIMESTAMPInternal(n2, (TIMESTAMP)object);
                    break;
                }
                if (object instanceof Timestamp) {
                    this.setTimestampInternal(n2, (Timestamp)object);
                    break;
                }
                if (object instanceof Date) {
                    this.setTIMESTAMPInternal(n2, new TIMESTAMP((Date)object));
                    break;
                }
                if (object instanceof DATE) {
                    this.setTIMESTAMPInternal(n2, new TIMESTAMP(((DATE)object).timestampValue()));
                    break;
                }
                if (object instanceof String) {
                    this.setTimestampInternal(n2, Timestamp.valueOf((String)object));
                    break;
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 132);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            case -100: {
                this.setTIMESTAMPInternal(n2, (TIMESTAMP)object);
                break;
            }
            case -101: {
                this.setTIMESTAMPTZInternal(n2, (TIMESTAMPTZ)object);
                break;
            }
            case -102: {
                this.setTIMESTAMPLTZInternal(n2, (TIMESTAMPLTZ)object);
                break;
            }
            case -103: {
                this.setINTERVALYMInternal(n2, (INTERVALYM)object);
                break;
            }
            case -104: {
                this.setINTERVALDSInternal(n2, (INTERVALDS)object);
                break;
            }
            case -8: {
                this.setROWIDInternal(n2, (ROWID)object);
                break;
            }
            case 100: {
                this.setBinaryFloatInternal(n2, (BINARY_FLOAT)object);
                break;
            }
            case 101: {
                this.setBinaryDoubleInternal(n2, (BINARY_DOUBLE)object);
                break;
            }
            case 2004: {
                this.setBLOBInternal(n2, (BLOB)object);
                break;
            }
            case 2005: 
            case 2011: {
                this.setCLOBInternal(n2, (CLOB)object);
                if (!((CLOB)object).isNCLOB()) break;
                this.setFormOfUse(n2, (short)2);
                break;
            }
            case -13: {
                this.setBFILEInternal(n2, (BFILE)object);
                break;
            }
            case 2002: 
            case 2008: {
                this.setSTRUCTInternal(n2, STRUCT.toSTRUCT(object, this.connection));
                break;
            }
            case 2003: {
                this.setARRAYInternal(n2, ARRAY.toARRAY(object, this.connection));
                break;
            }
            case 2007: {
                this.setOPAQUEInternal(n2, (OPAQUE)object);
                break;
            }
            case 2006: {
                this.setREFInternal(n2, (REF)object);
                break;
            }
            case 2009: {
                this.setSQLXMLInternal(n2, (SQLXML)object);
                break;
            }
            default: {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        }
    }

    @Override
    public void setObjectAtName(String string, Object object, int n2, int n3) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl = false;
        int n4 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n4; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setObjectInternal(i2 + 1, object);
            bl = true;
        }
        if (!bl) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    @Override
    public void setObject(int n2, Object object, int n3) throws SQLException {
        this.setObjectInternal(n2, object, n3, 0);
    }

    void setObjectInternal(int n2, Object object, int n3) throws SQLException {
        this.setObjectInternal(n2, object, n3, 0);
    }

    @Override
    public void setRefType(int n2, REF rEF) throws SQLException {
        this.setREFInternal(n2, rEF);
    }

    void setRefTypeInternal(int n2, REF rEF) throws SQLException {
        this.setREFInternal(n2, rEF);
    }

    @Override
    public void setRef(int n2, Ref ref) throws SQLException {
        this.setREFInternal(n2, (REF)ref);
    }

    void setRefInternal(int n2, Ref ref) throws SQLException {
        this.setREFInternal(n2, (REF)ref);
    }

    @Override
    public void setREF(int n2, REF rEF) throws SQLException {
        this.setREFInternal(n2, rEF);
    }

    void setREFInternal(int n2, REF rEF) throws SQLException {
        int n3 = n2 - 1;
        if (n3 < 0 || n2 > this.numberOfBindPositions) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (rEF == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.setREFCritical(n3, rEF);
        this.currentRowCharLens[n3] = 0;
    }

    void setREFCritical(int n2, REF rEF) throws SQLException {
        StructDescriptor structDescriptor = rEF.getDescriptor();
        if (structDescriptor == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 52);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.currentRowBinders[n2] = this.theRefTypeBinder;
        if (this.parameterDatum == null) {
            this.parameterDatum = new byte[this.numberOfBindRowsAllocated][this.numberOfBindPositions][];
        }
        this.parameterDatum[this.currentRank][n2] = rEF.getBytes();
        OracleTypeADT oracleTypeADT = structDescriptor.getOracleTypeADT();
        oracleTypeADT.getTOID();
        if (this.parameterOtype == null) {
            this.parameterOtype = new OracleTypeADT[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
        }
        this.parameterOtype[this.currentRank][n2] = oracleTypeADT;
    }

    @Override
    public void setObject(int n2, Object object) throws SQLException {
        this.setObjectInternal(n2, object);
    }

    void setObjectInternal(int n2, Object object) throws SQLException {
        if (object instanceof ORAData) {
            this.setORADataInternal(n2, (ORAData)object);
        } else if (object instanceof CustomDatum) {
            this.setCustomDatumInternal(n2, (CustomDatum)object);
        } else {
            int n3 = this.sqlTypeForObject(object);
            this.setObjectInternal(n2, object, n3, 0);
        }
    }

    @Override
    public void setOracleObject(int n2, Datum datum) throws SQLException {
        this.setObjectInternal(n2, datum);
    }

    void setOracleObjectInternal(int n2, Datum datum) throws SQLException {
        this.setObjectInternal(n2, datum);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPlsqlIndexTable(int n2, Object object, int n3, int n4, int n5, int n6) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.setPlsqlIndexTableInternal(n2, object, n3, n4, n5, n6);
        }
    }

    void setPlsqlIndexTableInternal(int n2, Object object, int n3, int n4, int n5, int n6) throws SQLException {
        Object object2;
        int n7 = n2 - 1;
        if (n7 < 0 || n2 > this.numberOfBindPositions) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (object == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 271);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        int n8 = this.getInternalType(n5);
        Object[] objectArray = null;
        switch (n8) {
            case 1: 
            case 96: {
                object2 = null;
                int n9 = 0;
                if (object instanceof CHAR[]) {
                    CHAR[] cHARArray = (CHAR[])object;
                    n9 = cHARArray.length;
                    object2 = new String[n9];
                    for (int i2 = 0; i2 < n9; ++i2) {
                        CHAR cHAR = cHARArray[i2];
                        if (cHAR == null) continue;
                        object2[i2] = cHAR.getString();
                    }
                } else if (object instanceof String[]) {
                    object2 = (String[])object;
                    n9 = ((String[])object2).length;
                } else {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 97);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                if (n6 == 0 && object2 != null) {
                    for (int i3 = 0; i3 < n9; ++i3) {
                        Object object3 = object2[i3];
                        if (object3 == null || n6 >= ((String)object3).length()) continue;
                        n6 = ((String)object3).length();
                    }
                }
                objectArray = object2;
                break;
            }
            case 2: 
            case 6: {
                objectArray = OracleTypeNUMBER.toNUMBERArray(object, this.connection, 1L, n4);
                if (n6 == 0 && objectArray != null) {
                    n6 = 22;
                }
                this.currentRowCharLens[n7] = 0;
                break;
            }
            default: {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 97);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        }
        if (objectArray.length == 0 && n3 == 0) {
            object2 = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 272);
            ((Throwable)object2).fillInStackTrace();
            throw object2;
        }
        this.currentRowBinders[n7] = this.thePlsqlIbtBinder;
        if (this.parameterPlsqlIbt == null) {
            this.parameterPlsqlIbt = new PlsqlIbtBindInfo[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
        }
        this.parameterPlsqlIbt[this.currentRank][n7] = new PlsqlIbtBindInfo(objectArray, n3, n4, n8, n6);
        this.hasIbtBind = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPlsqlIndexTableAtName(String string, Object object, int n2, int n3, int n4, int n5) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            String string2 = string.intern();
            String[] stringArray = this.sqlObject.getParameterList();
            boolean bl = false;
            int n6 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
            for (int i2 = 0; i2 < n6; ++i2) {
                if (stringArray[i2] != string2) continue;
                this.setPlsqlIndexTableInternal(i2 + 1, object, n2, n3, n4, n5);
                bl = true;
            }
            if (!bl) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        }
    }

    @Override
    void endOfResultSet(boolean bl) throws SQLException {
        if (!bl) {
            this.prepareForNewResults(false, false);
        }
        this.rowPrefetchInLastFetch = -1;
    }

    int sqlTypeForObject(Object object) {
        if (object == null) {
            return 0;
        }
        if (!(object instanceof Datum)) {
            if (object instanceof String) {
                return this.fixedString ? 999 : 12;
            }
            if (object instanceof BigDecimal) {
                return 2;
            }
            if (object instanceof Boolean) {
                return -7;
            }
            if (object instanceof Integer) {
                return 4;
            }
            if (object instanceof Long) {
                return -5;
            }
            if (object instanceof Float) {
                return 7;
            }
            if (object instanceof Double) {
                return 8;
            }
            if (object instanceof byte[]) {
                return -3;
            }
            if (object instanceof Short) {
                return 5;
            }
            if (object instanceof Byte) {
                return -6;
            }
            if (object instanceof Date) {
                return 91;
            }
            if (object instanceof Time) {
                return 92;
            }
            if (object instanceof Timestamp) {
                return 93;
            }
            if (object instanceof SQLData) {
                return 2002;
            }
            if (object instanceof ObjectData) {
                return 2002;
            }
        } else {
            if (object instanceof BINARY_FLOAT) {
                return 100;
            }
            if (object instanceof BINARY_DOUBLE) {
                return 101;
            }
            if (object instanceof BLOB) {
                return 2004;
            }
            if (object instanceof CLOB) {
                return 2005;
            }
            if (object instanceof BFILE) {
                return -13;
            }
            if (object instanceof ROWID) {
                return -8;
            }
            if (object instanceof NUMBER) {
                return 2;
            }
            if (object instanceof DATE) {
                return 91;
            }
            if (object instanceof TIMESTAMP) {
                return 93;
            }
            if (object instanceof TIMESTAMPTZ) {
                return -101;
            }
            if (object instanceof TIMESTAMPLTZ) {
                return -102;
            }
            if (object instanceof REF) {
                return 2006;
            }
            if (object instanceof CHAR) {
                return 1;
            }
            if (object instanceof RAW) {
                return -2;
            }
            if (object instanceof ARRAY) {
                return 2003;
            }
            if (object instanceof STRUCT) {
                return 2002;
            }
            if (object instanceof OPAQUE) {
                return 2007;
            }
            if (object instanceof INTERVALYM) {
                return -103;
            }
            if (object instanceof INTERVALDS) {
                return -104;
            }
            if (object instanceof SQLXML) {
                return 2009;
            }
        }
        return 1111;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearParameters() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.clearParameters = true;
            for (int i2 = 0; i2 < this.numberOfBindPositions; ++i2) {
                this.currentRowBinders[i2] = null;
            }
        }
    }

    void printByteArray(byte[] byArray) {
        if (byArray != null) {
            int n2 = byArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                int n3 = byArray[i2] & 0xFF;
                if (n3 >= 16) continue;
            }
        }
    }

    @Override
    public void setCharacterStream(int n2, Reader reader, int n3) throws SQLException {
        this.setCharacterStreamInternal(n2, reader, n3);
    }

    void setCharacterStreamInternal(int n2, Reader reader, int n3) throws SQLException {
        this.setCharacterStreamInternal(n2, reader, n3, true);
    }

    void setCharacterStreamInternal(int n2, Reader reader, long l2, boolean bl) throws SQLException {
        int n3 = n2 - 1;
        if (n3 < 0 || n2 > this.numberOfBindPositions) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.set_execute_batch(1);
        this.checkUserStreamForDuplicates(reader, n3);
        if (reader == null) {
            this.basicBindNullString(n2);
        } else {
            if (!(this.userRsetType == 1 || l2 <= (long)this.maxVcsCharsSql && bl)) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 169);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (!bl) {
                this.setReaderContentsForClobCritical(n2, reader, l2, bl);
            } else if (this.currentRowFormOfUse[n3] == 1) {
                if (this.sqlKind.isPlsqlOrCall()) {
                    if (l2 > (long)this.maxVcsBytesPlsql || l2 > (long)this.maxVcsCharsPlsql && this.isServerCharSetFixedWidth) {
                        this.setReaderContentsForClobCritical(n2, reader, l2, bl);
                    } else if (l2 <= (long)this.maxVcsCharsPlsql) {
                        this.setReaderContentsForStringInternal(n2, reader, (int)l2);
                    } else {
                        this.setReaderContentsForStringOrClobInVariableWidthCase(n2, reader, (int)l2, false);
                    }
                } else if (l2 <= (long)this.maxVcsCharsSql) {
                    this.setReaderContentsForStringInternal(n2, reader, (int)l2);
                } else if (l2 > Integer.MAX_VALUE) {
                    this.setReaderContentsForClobCritical(n2, reader, l2, bl);
                } else {
                    this.basicBindCharacterStream(n2, reader, (int)l2, false);
                }
            } else if (this.sqlKind.isPlsqlOrCall()) {
                if (l2 > (long)this.maxVcsBytesPlsql || l2 > (long)this.maxVcsNCharsPlsql && this.isServerCharSetFixedWidth) {
                    this.setReaderContentsForClobCritical(n2, reader, l2, bl);
                } else if (l2 <= (long)this.maxVcsNCharsPlsql) {
                    this.setReaderContentsForStringInternal(n2, reader, (int)l2);
                } else {
                    this.setReaderContentsForStringOrClobInVariableWidthCase(n2, reader, (int)l2, true);
                }
            } else if (l2 <= (long)this.maxVcsNCharsSql) {
                this.setReaderContentsForStringInternal(n2, reader, (int)l2);
            } else {
                this.setReaderContentsForClobCritical(n2, reader, l2, bl);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void basicBindCharacterStream(int n2, Reader reader, int n3, boolean bl) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            int n4 = n2 - 1;
            this.currentRowBinders[n4] = bl ? this.theLongStreamForStringBinder : this.theLongStreamBinder;
            if (this.parameterStream == null) {
                this.parameterStream = new InputStream[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
            }
            this.parameterStream[this.currentRank][n4] = bl ? this.connection.conversion.ConvertStreamInternal(reader, 7, n3, this.currentRowFormOfUse[n4]) : this.connection.conversion.ConvertStream(reader, 7, n3, this.currentRowFormOfUse[n4]);
            this.currentRowCharLens[n4] = 0;
        }
    }

    void setReaderContentsForStringOrClobInVariableWidthCase(int n2, Reader reader, int n3, boolean bl) throws SQLException {
        int n4;
        char[] cArray = new char[n3];
        int n5 = 0;
        try {
            int n6;
            for (int i2 = n3; i2 > 0 && (n6 = reader.read(cArray, n5, i2)) != -1; i2 -= n6) {
                n5 += n6;
            }
        }
        catch (IOException iOException) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (n5 != n3) {
            char[] cArray2 = new char[n5];
            System.arraycopy(cArray, 0, cArray2, 0, n5);
            cArray = cArray2;
        }
        if ((n4 = this.connection.conversion.encodedByteLength(cArray, bl)) < this.maxVcsBytesPlsql) {
            this.setStringInternal(n2, new String(cArray));
        } else {
            this.setStringForClobCritical(n2, new String(cArray));
        }
    }

    void setReaderContentsForStringInternal(int n2, Reader reader, int n3) throws SQLException {
        char[] cArray = new char[n3];
        int n4 = 0;
        try {
            int n5;
            for (int i2 = n3; i2 > 0 && (n5 = reader.read(cArray, n4, i2)) != -1; i2 -= n5) {
                n4 += n5;
            }
        }
        catch (IOException iOException) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (n4 != n3) {
            char[] cArray2 = new char[n4];
            System.arraycopy(cArray, 0, cArray2, 0, n4);
            cArray = cArray2;
        }
        this.setStringInternal(n2, new String(cArray));
    }

    @Override
    public void setDate(int n2, Date date, Calendar calendar) throws SQLException {
        this.setDATEInternal(n2, date == null ? null : new DATE(date, calendar));
    }

    void setDateInternal(int n2, Date date, Calendar calendar) throws SQLException {
        this.setDATEInternal(n2, date == null ? null : new DATE(date, calendar));
    }

    @Override
    public void setTime(int n2, Time time, Calendar calendar) throws SQLException {
        this.setDATEInternal(n2, time == null ? null : new DATE(time, calendar));
    }

    void setTimeInternal(int n2, Time time, Calendar calendar) throws SQLException {
        this.setDATEInternal(n2, time == null ? null : new DATE(time, calendar));
    }

    @Override
    public void setTimestamp(int n2, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.setTimestampInternal(n2, timestamp, calendar);
    }

    void setTimestampInternal(int n2, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.setTIMESTAMPInternal(n2, timestamp == null ? null : new TIMESTAMP(timestamp, calendar));
    }

    @Override
    public void setCheckBindTypes(boolean bl) {
        this.checkBindTypes = bl;
    }

    final void setOracleBatchStyle() throws SQLException {
        if (this.m_batchStyle == 2) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "operation cannot be mixed with JDBC-2.0-style batching");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.m_batchStyle == 0) {
            // empty if block
        }
        this.m_batchStyle = 1;
    }

    @Override
    boolean isOracleBatchStyle() {
        return this.m_batchStyle == 1;
    }

    final void setJdbcBatchStyle() throws SQLException {
        if (this.m_batchStyle == 1) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "operation cannot be mixed with Oracle-style batching");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.m_batchStyle = 2;
    }

    @Override
    final void checkIfJdbcBatchExists() throws SQLException {
        if (this.doesJdbcBatchExist()) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 81, "batch must be either executed or cleared");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    boolean doesJdbcBatchExist() {
        return this.currentRank > 0 && this.m_batchStyle == 2;
    }

    boolean isJdbcBatchStyle() {
        return this.m_batchStyle == 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addBatch() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.setJdbcBatchStyle();
            this.processCompletedBindRow(this.currentRank + 2, this.currentRank > 0 && this.sqlKind.isPlsqlOrCall());
            ++this.currentRank;
        }
    }

    @Override
    public void addBatch(String string) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            SQLException sQLException = DatabaseError.createUnsupportedFeatureSqlException();
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearBatch() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            for (int i2 = this.currentRank - 1; i2 >= 0; --i2) {
                for (int i3 = 0; i3 < this.numberOfBindPositions; ++i3) {
                    this.binders[i2][i3] = null;
                }
            }
            this.currentRank = 0;
            if (this.binders != null) {
                this.currentRowBinders = this.binders[0];
            }
            this.pushedBatches = null;
            this.pushedBatchesTail = null;
            this.firstRowInBatch = 0;
            this.clearParameters = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void executeForRowsWithTimeout(boolean bl) throws SQLException {
        if (this.queryTimeout > 0) {
            try {
                this.connection.getTimeout().setTimeout(this.queryTimeout * 1000, this);
                this.isExecuting = true;
                this.executeForRows(bl);
            }
            finally {
                this.connection.getTimeout().cancelTimeout();
                this.isExecuting = false;
            }
        }
        try {
            this.isExecuting = true;
            this.executeForRows(bl);
        }
        finally {
            this.isExecuting = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] executeBatch() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            int[] nArray = new int[this.currentRank];
            this.checkSum = 0L;
            this.checkSumComputationFailure = false;
            int n2 = 0;
            this.cleanOldTempLobs();
            this.setJdbcBatchStyle();
            if (this.currentRank > 0) {
                this.ensureOpen();
                this.prepareForNewResults(true, true);
                if (this.sqlKind.isSELECT()) {
                    BatchUpdateException batchUpdateException = DatabaseError.createBatchUpdateException(80, 0, null);
                    batchUpdateException.fillInStackTrace();
                    throw batchUpdateException;
                }
                this.noMoreUpdateCounts = false;
                int n3 = 0;
                try {
                    this.connection.registerHeartbeat();
                    this.connection.needLine();
                    if (!this.isOpen) {
                        this.connection.open(this);
                        this.isOpen = true;
                    }
                    int n4 = this.currentRank;
                    if (this.pushedBatches == null) {
                        this.setupBindBuffers(0, this.currentRank);
                        this.executeForRowsWithTimeout(false);
                    } else {
                        if (this.currentRank > this.firstRowInBatch) {
                            this.pushBatch(true);
                        }
                        boolean bl = this.needToParse;
                        do {
                            PushedBatch pushedBatch = this.pushedBatches;
                            this.currentBatchCharLens = pushedBatch.currentBatchCharLens;
                            this.lastBoundCharLens = pushedBatch.lastBoundCharLens;
                            this.lastBoundNeeded = pushedBatch.lastBoundNeeded;
                            this.currentBatchBindAccessors = pushedBatch.currentBatchBindAccessors;
                            this.needToParse = pushedBatch.need_to_parse;
                            this.currentBatchNeedToPrepareBinds = pushedBatch.current_batch_need_to_prepare_binds;
                            this.firstRowInBatch = pushedBatch.first_row_in_batch;
                            this.setupBindBuffers(pushedBatch.first_row_in_batch, pushedBatch.number_of_rows_to_be_bound);
                            this.currentRank = pushedBatch.number_of_rows_to_be_bound;
                            this.executeForRowsWithTimeout(false);
                            n3 += this.validRows;
                            if (this.sqlKind.isPlsqlOrCall()) {
                                nArray[n2++] = this.validRows;
                            }
                            this.pushedBatches = pushedBatch.next;
                        } while (this.pushedBatches != null);
                        this.pushedBatchesTail = null;
                        this.firstRowInBatch = 0;
                        this.needToParse = bl;
                    }
                    this.slideDownCurrentRow(n4);
                }
                catch (SQLException sQLException) {
                    int n5 = this.currentRank;
                    this.clearBatch();
                    this.needToParse = true;
                    if (!this.sqlKind.isPlsqlOrCall()) {
                        if (this.numberOfExecutedElementsInBatch != -1 && this.numberOfExecutedElementsInBatch != n5) {
                            nArray = new int[this.numberOfExecutedElementsInBatch];
                            for (n2 = 0; n2 < this.numberOfExecutedElementsInBatch; ++n2) {
                                nArray[n2] = -2;
                            }
                        } else {
                            for (n2 = 0; n2 < nArray.length; ++n2) {
                                nArray[n2] = -3;
                            }
                        }
                    }
                    this.resetCurrentRowBinders();
                    BatchUpdateException batchUpdateException = DatabaseError.createBatchUpdateException(sQLException, this.sqlKind.isPlsqlOrCall() ? n2 : nArray.length, nArray);
                    batchUpdateException.fillInStackTrace();
                    throw batchUpdateException;
                }
                finally {
                    if (this.sqlKind.isPlsqlOrCall() || n3 > this.validRows) {
                        this.validRows = n3;
                    }
                    this.checkValidRowsStatus();
                    this.currentRank = 0;
                }
                if (this.validRows < 0) {
                    for (n2 = 0; n2 < nArray.length; ++n2) {
                        nArray[n2] = -3;
                    }
                    BatchUpdateException batchUpdateException = DatabaseError.createBatchUpdateException(81, 0, nArray);
                    batchUpdateException.fillInStackTrace();
                    throw batchUpdateException;
                }
                if (!this.sqlKind.isPlsqlOrCall()) {
                    for (n2 = 0; n2 < nArray.length; ++n2) {
                        nArray[n2] = -2;
                    }
                }
            }
            this.connection.registerHeartbeat();
            return nArray;
        }
    }

    void pushBatch(boolean bl) {
        PushedBatch pushedBatch = new PushedBatch();
        pushedBatch.currentBatchCharLens = new int[this.numberOfBindPositions];
        System.arraycopy(this.currentBatchCharLens, 0, pushedBatch.currentBatchCharLens, 0, this.numberOfBindPositions);
        pushedBatch.lastBoundCharLens = new int[this.numberOfBindPositions];
        System.arraycopy(this.lastBoundCharLens, 0, pushedBatch.lastBoundCharLens, 0, this.numberOfBindPositions);
        if (this.currentBatchBindAccessors != null) {
            pushedBatch.currentBatchBindAccessors = new Accessor[this.numberOfBindPositions];
            System.arraycopy(this.currentBatchBindAccessors, 0, pushedBatch.currentBatchBindAccessors, 0, this.numberOfBindPositions);
        }
        pushedBatch.lastBoundNeeded = this.lastBoundNeeded;
        pushedBatch.need_to_parse = this.needToParse;
        pushedBatch.current_batch_need_to_prepare_binds = this.currentBatchNeedToPrepareBinds;
        pushedBatch.first_row_in_batch = this.firstRowInBatch;
        pushedBatch.number_of_rows_to_be_bound = this.currentRank - this.firstRowInBatch;
        if (this.pushedBatches == null) {
            this.pushedBatches = pushedBatch;
        } else {
            this.pushedBatchesTail.next = pushedBatch;
        }
        this.pushedBatchesTail = pushedBatch;
        if (!bl) {
            int[] nArray = this.currentBatchCharLens;
            this.currentBatchCharLens = this.lastBoundCharLens;
            this.lastBoundCharLens = nArray;
            this.lastBoundNeeded = false;
            for (int i2 = 0; i2 < this.numberOfBindPositions; ++i2) {
                this.currentBatchCharLens[i2] = 0;
            }
            this.firstRowInBatch = this.currentRank;
        }
    }

    int doScrollPstmtExecuteUpdate() throws SQLException {
        this.doScrollExecuteCommon();
        if (this.sqlKind.isSELECT()) {
            this.scrollRsetTypeSolved = true;
        }
        return this.validRows;
    }

    @Override
    public int copyBinds(Statement statement, int n2) throws SQLException {
        if (this.numberOfBindPositions > 0) {
            OraclePreparedStatement oraclePreparedStatement = (OraclePreparedStatement)statement;
            int n3 = this.bindIndicatorSubRange + 5;
            int n4 = this.bindByteSubRange;
            int n5 = this.bindCharSubRange;
            int n6 = this.indicatorsOffset;
            int n7 = this.valueLengthsOffset;
            for (int i2 = 0; i2 < this.numberOfBindPositions; ++i2) {
                Object object;
                short s2 = this.bindIndicators[n3 + 0];
                short s3 = this.bindIndicators[n3 + 1];
                int n8 = this.bindIndicators[n3 + 2];
                int n9 = i2 + n2;
                if (oraclePreparedStatement.parameterDatum == null) {
                    oraclePreparedStatement.parameterDatum = new byte[oraclePreparedStatement.numberOfBindRowsAllocated][oraclePreparedStatement.numberOfBindPositions][];
                }
                if (oraclePreparedStatement.parameterOtype == null) {
                    oraclePreparedStatement.parameterOtype = new OracleTypeADT[oraclePreparedStatement.numberOfBindRowsAllocated][oraclePreparedStatement.numberOfBindPositions];
                }
                if (this.bindIndicators[n6] == -1) {
                    oraclePreparedStatement.currentRowBinders[n9] = this.copiedNullBinder(s2, s3);
                    if (n8 > 0) {
                        oraclePreparedStatement.currentRowCharLens[n9] = 1;
                    }
                } else if (s2 == 109 || s2 == 111) {
                    oraclePreparedStatement.currentRowBinders[n9] = s2 == 109 ? this.theNamedTypeBinder : this.theRefTypeBinder;
                    object = this.parameterDatum[0][i2];
                    int n10 = ((byte[])object).length;
                    byte[] byArray = new byte[n10];
                    oraclePreparedStatement.parameterDatum[0][n9] = byArray;
                    System.arraycopy(object, 0, byArray, 0, n10);
                    oraclePreparedStatement.parameterOtype[0][n9] = this.parameterOtype[0][i2];
                } else if (s3 > 0) {
                    oraclePreparedStatement.currentRowBinders[n9] = this.copiedByteBinder(s2, this.bindBytes, n4, s3, this.bindIndicators[n7]);
                } else if (n8 > 0) {
                    oraclePreparedStatement.currentRowBinders[n9] = this.copiedCharBinder(s2, this.bindChars, n5, n8, this.bindIndicators[n7], this.getInoutIndicator(i2));
                    oraclePreparedStatement.currentRowCharLens[n9] = n8;
                } else {
                    object = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 89, "copyBinds doesn't understand type " + s2);
                    ((Throwable)object).fillInStackTrace();
                    throw object;
                }
                n4 += this.bindBufferCapacity * s3;
                n5 += this.bindBufferCapacity * n8;
                n6 += this.numberOfBindRowsAllocated;
                n7 += this.numberOfBindRowsAllocated;
                n3 += 10;
            }
        }
        return this.numberOfBindPositions;
    }

    Binder copiedNullBinder(short s2, int n2) throws SQLException {
        return new CopiedNullBinder(s2, n2);
    }

    Binder copiedByteBinder(short s2, byte[] byArray, int n2, int n3, short s3) throws SQLException {
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, n2, byArray2, 0, n3);
        return new CopiedByteBinder(s2, n3, byArray2, s3);
    }

    Binder copiedCharBinder(short s2, char[] cArray, int n2, int n3, short s3, short s4) throws SQLException {
        char[] cArray2 = new char[n3];
        System.arraycopy(cArray, n2, cArray2, 0, n3);
        return new CopiedCharBinder(s2, cArray2, s3, s4);
    }

    @Override
    protected void hardClose() throws SQLException {
        super.hardClose();
        this.connection.cacheBuffer(this.bindBytes);
        this.bindBytes = null;
        this.connection.cacheBuffer(this.bindChars);
        this.bindChars = null;
        this.bindIndicators = null;
        if (!this.connection.isClosed()) {
            this.cleanAllTempLobs();
        }
        this.lastBoundBytes = null;
        this.lastBoundChars = null;
        this.clearParameters();
    }

    @Override
    protected void alwaysOnClose() throws SQLException {
        if (this.currentRank > 0) {
            if (this.m_batchStyle == 2) {
                this.clearBatch();
            } else {
                int n2 = this.validRows;
                this.prematureBatchCount = this.sendBatch();
                this.validRows = n2;
            }
        }
        super.alwaysOnClose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDisableStmtCaching(boolean bl) {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (bl) {
                this.cacheState = 3;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFormOfUse(int n2, short s2) {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            int n3 = n2 - 1;
            if (this.currentRowFormOfUse[n3] != s2) {
                Accessor accessor;
                this.currentRowFormOfUse[n3] = s2;
                if (this.currentRowBindAccessors != null && (accessor = this.currentRowBindAccessors[n3]) != null) {
                    accessor.setFormOfUse(s2);
                }
                if (this.returnParamAccessors != null && (accessor = this.returnParamAccessors[n3]) != null) {
                    accessor.setFormOfUse(s2);
                }
            }
        }
    }

    @Override
    public void setURL(int n2, URL uRL) throws SQLException {
        this.setURLInternal(n2, uRL);
    }

    void setURLInternal(int n2, URL uRL) throws SQLException {
        this.setStringInternal(n2, uRL.toString());
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        return new OracleParameterMetaData(this.sqlObject.getParameterCount());
    }

    @Override
    public oracle.jdbc.OracleParameterMetaData OracleGetParameterMetaData() throws SQLException {
        SQLException sQLException = DatabaseError.createUnsupportedFeatureSqlException();
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    @Override
    public void registerReturnParameter(int n2, int n3) throws SQLException {
        int n4;
        if (this.numberOfBindPositions <= 0) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.numReturnParams <= 0) {
            this.numReturnParams = this.sqlObject.getReturnParameterCount();
            if (this.numReturnParams <= 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        }
        if ((n4 = n2 - 1) < this.numberOfBindPositions - this.numReturnParams || n2 > this.numberOfBindPositions) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        int n5 = this.getInternalTypeForDmlReturning(n3);
        short s2 = 0;
        if (this.currentRowFormOfUse != null && this.currentRowFormOfUse[n4] != 0) {
            s2 = this.currentRowFormOfUse[n4];
        }
        this.registerReturnParameterInternal(n4, n5, n3, -1, s2, null);
        this.currentRowBinders[n4] = this.theReturnParamBinder;
    }

    @Override
    public void registerReturnParameter(int n2, int n3, int n4) throws SQLException {
        if (this.numberOfBindPositions <= 0) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        int n5 = n2 - 1;
        if (n5 < 0 || n2 > this.numberOfBindPositions) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (n3 != 1 && n3 != 12 && n3 != -1 && n3 != -2 && n3 != -3 && n3 != -4 && n3 != 12) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (n4 <= 0) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        int n6 = this.getInternalTypeForDmlReturning(n3);
        short s2 = 0;
        if (this.currentRowFormOfUse != null && this.currentRowFormOfUse[n5] != 0) {
            s2 = this.currentRowFormOfUse[n5];
        }
        this.registerReturnParameterInternal(n5, n6, n3, n4, s2, null);
        this.currentRowBinders[n5] = this.theReturnParamBinder;
    }

    @Override
    public void registerReturnParameter(int n2, int n3, String string) throws SQLException {
        if (this.numberOfBindPositions <= 0) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        int n4 = n2 - 1;
        if (n4 < 0 || n2 > this.numberOfBindPositions) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        int n5 = this.getInternalTypeForDmlReturning(n3);
        if (n5 != 111 && n5 != 109) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.registerReturnParameterInternal(n4, n5, n3, -1, (short)0, string);
        this.currentRowBinders[n4] = this.theReturnParamBinder;
    }

    @Override
    public ResultSet getReturnResultSet() throws SQLException {
        if (this.closed) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.returnParamAccessors == null || this.numReturnParams == 0) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 144);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.returnResultSet == null || this.numReturnParams == 0 || !this.isOpen) {
            this.returnResultSet = new OracleReturnResultSet(this);
        }
        return this.returnResultSet;
    }

    int getInternalTypeForDmlReturning(int n2) throws SQLException {
        int n3 = 0;
        switch (n2) {
            case -7: 
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n3 = 6;
                break;
            }
            case 100: {
                n3 = 100;
                break;
            }
            case 101: {
                n3 = 101;
                break;
            }
            case -15: 
            case 1: {
                n3 = 96;
                break;
            }
            case -9: 
            case 12: {
                n3 = 1;
                break;
            }
            case -16: 
            case -1: {
                n3 = 8;
                break;
            }
            case 91: 
            case 92: {
                n3 = 12;
                break;
            }
            case 93: {
                n3 = 180;
                break;
            }
            case -101: {
                n3 = 181;
                break;
            }
            case -102: {
                n3 = 231;
                break;
            }
            case -103: {
                n3 = 182;
                break;
            }
            case -104: {
                n3 = 183;
                break;
            }
            case -3: 
            case -2: {
                n3 = 23;
                break;
            }
            case -4: {
                n3 = 24;
                break;
            }
            case -8: {
                n3 = 104;
                break;
            }
            case 2004: {
                n3 = 113;
                break;
            }
            case 2005: 
            case 2011: {
                n3 = 112;
                break;
            }
            case -13: {
                n3 = 114;
                break;
            }
            case 2002: 
            case 2003: 
            case 2007: 
            case 2008: 
            case 2009: {
                n3 = 109;
                break;
            }
            case 2006: {
                n3 = 111;
                break;
            }
            case 70: {
                n3 = 1;
                break;
            }
            default: {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        }
        return n3;
    }

    void registerReturnParamsForAutoKey() throws SQLException {
        int[] nArray = this.autoKeyInfo.returnTypes;
        short[] sArray = this.autoKeyInfo.tableFormOfUses;
        int[] nArray2 = this.autoKeyInfo.columnIndexes;
        int n2 = nArray.length;
        int n3 = this.numberOfBindPositions - n2;
        for (int i2 = 0; i2 < n2; ++i2) {
            short s2;
            int n4 = n3 + i2;
            this.currentRowBinders[n4] = this.theReturnParamBinder;
            short s3 = s2 = this.connection.defaultnchar ? (short)2 : 1;
            if (sArray != null && nArray2 != null && sArray[nArray2[i2] - 1] == 2) {
                s2 = 2;
                this.setFormOfUse(n4 + 1, s2);
            }
            this.checkTypeForAutoKey(nArray[i2]);
            String string = null;
            if (nArray[i2] == 111) {
                string = this.autoKeyInfo.tableTypeNames[nArray2[i2] - 1];
            }
            this.registerReturnParameterInternal(n4, nArray[i2], nArray[i2], -1, s2, string);
        }
    }

    @Override
    void cleanOldTempLobs() {
        if (this.m_batchStyle != 1 || this.currentRank == this.batch - 1) {
            super.cleanOldTempLobs();
        }
    }

    @Override
    void resetOnExceptionDuringExecute() {
        super.resetOnExceptionDuringExecute();
        this.currentRank = 0;
        this.currentBatchNeedToPrepareBinds = true;
    }

    @Override
    void resetCurrentRowBinders() {
        Binder[] binderArray = this.currentRowBinders;
        if (this.binders != null && this.currentRowBinders != null && binderArray != this.binders[0]) {
            this.currentRowBinders = this.binders[0];
            this.binders[this.numberOfBoundRows] = binderArray;
        }
    }

    @Override
    public void setAsciiStream(int n2, InputStream inputStream) throws SQLException {
        this.setAsciiStreamInternal(n2, inputStream);
    }

    @Override
    public void setAsciiStream(int n2, InputStream inputStream, long l2) throws SQLException {
        this.setAsciiStreamInternal(n2, inputStream, l2);
    }

    @Override
    public void setBinaryStream(int n2, InputStream inputStream) throws SQLException {
        this.setBinaryStreamInternal(n2, inputStream);
    }

    @Override
    public void setBinaryStream(int n2, InputStream inputStream, long l2) throws SQLException {
        this.setBinaryStreamInternal(n2, inputStream, l2);
    }

    @Override
    public void setBlob(int n2, InputStream inputStream) throws SQLException {
        this.setBlobInternal(n2, inputStream);
    }

    @Override
    public void setBlob(int n2, InputStream inputStream, long l2) throws SQLException {
        if (l2 < 0L) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "length for setBlob() cannot be negative");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.setBlobInternal(n2, inputStream, l2);
    }

    @Override
    public void setCharacterStream(int n2, Reader reader) throws SQLException {
        this.setCharacterStreamInternal(n2, reader);
    }

    @Override
    public void setCharacterStream(int n2, Reader reader, long l2) throws SQLException {
        this.setCharacterStreamInternal(n2, reader, l2);
    }

    @Override
    public void setClob(int n2, Reader reader, long l2) throws SQLException {
        if (l2 < 0L) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "length for setClob() cannot be negative");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.setClobInternal(n2, reader, l2);
    }

    @Override
    public void setClob(int n2, Reader reader) throws SQLException {
        this.setClobInternal(n2, reader);
    }

    @Override
    public void setRowId(int n2, RowId rowId) throws SQLException {
        this.setRowIdInternal(n2, rowId);
    }

    @Override
    public void setNCharacterStream(int n2, Reader reader) throws SQLException {
        this.setNCharacterStreamInternal(n2, reader);
    }

    @Override
    public void setNCharacterStream(int n2, Reader reader, long l2) throws SQLException {
        this.setNCharacterStreamInternal(n2, reader, l2);
    }

    @Override
    public void setNClob(int n2, NClob nClob) throws SQLException {
        this.setNClobInternal(n2, nClob);
    }

    @Override
    public void setNClob(int n2, Reader reader, long l2) throws SQLException {
        this.setNClobInternal(n2, reader, l2);
    }

    @Override
    public void setNClob(int n2, Reader reader) throws SQLException {
        this.setNClobInternal(n2, reader);
    }

    @Override
    public void setSQLXML(int n2, SQLXML sQLXML) throws SQLException {
        this.setSQLXMLInternal(n2, sQLXML);
    }

    @Override
    public void setNString(int n2, String string) throws SQLException {
        this.setNStringInternal(n2, string);
    }

    void setAsciiStreamInternal(int n2, InputStream inputStream) throws SQLException {
        this.setAsciiStreamInternal(n2, inputStream, 0L, false);
    }

    void setAsciiStreamInternal(int n2, InputStream inputStream, long l2) throws SQLException {
        this.setAsciiStreamInternal(n2, inputStream, l2, true);
    }

    void setBinaryStreamInternal(int n2, InputStream inputStream) throws SQLException {
        this.setBinaryStreamInternal(n2, inputStream, 0L, false);
    }

    void setBinaryStreamInternal(int n2, InputStream inputStream, long l2) throws SQLException {
        this.setBinaryStreamInternal(n2, inputStream, l2, true);
    }

    void setBlobInternal(int n2, InputStream inputStream, long l2) throws SQLException {
        int n3 = n2 - 1;
        if (n3 < 0 || n2 > this.numberOfBindPositions) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (inputStream == null) {
            this.setNullInternal(n2, 2004);
        } else {
            this.setBinaryStreamContentsForBlobCritical(n2, inputStream, l2, l2 != -1L);
        }
    }

    void setBlobInternal(int n2, InputStream inputStream) throws SQLException {
        this.setBlobInternal(n2, inputStream, -1L);
    }

    void setCharacterStreamInternal(int n2, Reader reader) throws SQLException {
        this.setCharacterStreamInternal(n2, reader, 0L, false);
    }

    void setCharacterStreamInternal(int n2, Reader reader, long l2) throws SQLException {
        this.setCharacterStreamInternal(n2, reader, l2, true);
    }

    void setClobInternal(int n2, Reader reader) throws SQLException {
        this.setClobInternal(n2, reader, -1L);
    }

    void setClobInternal(int n2, Reader reader, long l2) throws SQLException {
        int n3 = n2 - 1;
        if (n3 < 0 || n2 > this.numberOfBindPositions) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (reader == null) {
            this.setNullInternal(n2, 2005);
        } else {
            this.setReaderContentsForClobCritical(n2, reader, l2, l2 != -1L);
        }
    }

    void setNCharacterStreamInternal(int n2, Reader reader) throws SQLException {
        this.setFormOfUse(n2, (short)2);
        this.setCharacterStreamInternal(n2, reader, 0L, false);
    }

    void setNCharacterStreamInternal(int n2, Reader reader, long l2) throws SQLException {
        this.setFormOfUse(n2, (short)2);
        this.setCharacterStreamInternal(n2, reader, l2);
    }

    void setNClobInternal(int n2, NClob nClob) throws SQLException {
        this.setFormOfUse(n2, (short)2);
        this.setClobInternal(n2, nClob);
    }

    void setNClobInternal(int n2, Reader reader) throws SQLException {
        this.setFormOfUse(n2, (short)2);
        this.setClobInternal(n2, reader);
    }

    void setNClobInternal(int n2, Reader reader, long l2) throws SQLException {
        this.setFormOfUse(n2, (short)2);
        this.setClobInternal(n2, reader, l2);
    }

    void setNStringInternal(int n2, String string) throws SQLException {
        this.setFormOfUse(n2, (short)2);
        this.setStringInternal(n2, string);
    }

    void setRowIdInternal(int n2, RowId rowId) throws SQLException {
        this.setROWIDInternal(n2, (ROWID)rowId);
    }

    @Override
    public void setArrayAtName(String string, Array array) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setArray(i2 + 1, array);
            bl = true;
        }
        if (!bl) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    @Override
    public void setBigDecimalAtName(String string, BigDecimal bigDecimal) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setBigDecimal(i2 + 1, bigDecimal);
            bl = true;
        }
        if (!bl) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    @Override
    public void setBlobAtName(String string, Blob blob) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setBlob(i2 + 1, blob);
            bl = true;
        }
        if (!bl) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    @Override
    public void setBooleanAtName(String string, boolean bl) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl2 = false;
        int n2 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setBoolean(i2 + 1, bl);
            bl2 = true;
        }
        if (!bl2) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    @Override
    public void setByteAtName(String string, byte by) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setByte(i2 + 1, by);
            bl = true;
        }
        if (!bl) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    @Override
    public void setBytesAtName(String string, byte[] byArray) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setBytes(i2 + 1, byArray);
            bl = true;
        }
        if (!bl) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    @Override
    public void setClobAtName(String string, Clob clob) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setClob(i2 + 1, clob);
            bl = true;
        }
        if (!bl) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    @Override
    public void setDateAtName(String string, Date date) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setDate(i2 + 1, date);
            bl = true;
        }
        if (!bl) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    @Override
    public void setDateAtName(String string, Date date, Calendar calendar) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setDate(i2 + 1, date, calendar);
            bl = true;
        }
        if (!bl) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    @Override
    public void setDoubleAtName(String string, double d2) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setDouble(i2 + 1, d2);
            bl = true;
        }
        if (!bl) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    @Override
    public void setFloatAtName(String string, float f2) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setFloat(i2 + 1, f2);
            bl = true;
        }
        if (!bl) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    @Override
    public void setIntAtName(String string, int n2) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl = false;
        int n3 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n3; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setInt(i2 + 1, n2);
            bl = true;
        }
        if (!bl) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    @Override
    public void setLongAtName(String string, long l2) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setLong(i2 + 1, l2);
            bl = true;
        }
        if (!bl) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    @Override
    public void setNClobAtName(String string, NClob nClob) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setNClob(i2 + 1, nClob);
            bl = true;
        }
        if (!bl) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    @Override
    public void setNStringAtName(String string, String string2) throws SQLException {
        String string3 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string3) continue;
            this.setNString(i2 + 1, string2);
            bl = true;
        }
        if (!bl) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    @Override
    public void setObjectAtName(String string, Object object) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setObject(i2 + 1, object);
            bl = true;
        }
        if (!bl) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    @Override
    public void setObjectAtName(String string, Object object, int n2) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl = false;
        int n3 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n3; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setObject(i2 + 1, object, n2);
            bl = true;
        }
        if (!bl) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    @Override
    public void setRefAtName(String string, Ref ref) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setRef(i2 + 1, ref);
            bl = true;
        }
        if (!bl) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    @Override
    public void setRowIdAtName(String string, RowId rowId) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setRowId(i2 + 1, rowId);
            bl = true;
        }
        if (!bl) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    @Override
    public void setShortAtName(String string, short s2) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setShort(i2 + 1, s2);
            bl = true;
        }
        if (!bl) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    @Override
    public void setSQLXMLAtName(String string, SQLXML sQLXML) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setSQLXML(i2 + 1, sQLXML);
            bl = true;
        }
        if (!bl) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    @Override
    public void setStringAtName(String string, String string2) throws SQLException {
        String string3 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string3) continue;
            this.setString(i2 + 1, string2);
            bl = true;
        }
        if (!bl) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    @Override
    public void setTimeAtName(String string, Time time) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setTime(i2 + 1, time);
            bl = true;
        }
        if (!bl) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    @Override
    public void setTimeAtName(String string, Time time, Calendar calendar) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setTime(i2 + 1, time, calendar);
            bl = true;
        }
        if (!bl) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    @Override
    public void setTimestampAtName(String string, Timestamp timestamp) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setTimestamp(i2 + 1, timestamp);
            bl = true;
        }
        if (!bl) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    @Override
    public void setTimestampAtName(String string, Timestamp timestamp, Calendar calendar) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setTimestamp(i2 + 1, timestamp, calendar);
            bl = true;
        }
        if (!bl) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    @Override
    public void setURLAtName(String string, URL uRL) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setURL(i2 + 1, uRL);
            bl = true;
        }
        if (!bl) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    @Override
    public void setARRAYAtName(String string, ARRAY aRRAY) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setARRAY(i2 + 1, aRRAY);
            bl = true;
        }
        if (!bl) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    @Override
    public void setBFILEAtName(String string, BFILE bFILE) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setBFILE(i2 + 1, bFILE);
            bl = true;
        }
        if (!bl) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    @Override
    public void setBfileAtName(String string, BFILE bFILE) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setBfile(i2 + 1, bFILE);
            bl = true;
        }
        if (!bl) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    @Override
    public void setBinaryFloatAtName(String string, float f2) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setBinaryFloat(i2 + 1, f2);
            bl = true;
        }
        if (!bl) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    @Override
    public void setBinaryFloatAtName(String string, BINARY_FLOAT bINARY_FLOAT) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setBinaryFloat(i2 + 1, bINARY_FLOAT);
            bl = true;
        }
        if (!bl) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    @Override
    public void setBinaryDoubleAtName(String string, double d2) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setBinaryDouble(i2 + 1, d2);
            bl = true;
        }
        if (!bl) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    @Override
    public void setBinaryDoubleAtName(String string, BINARY_DOUBLE bINARY_DOUBLE) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setBinaryDouble(i2 + 1, bINARY_DOUBLE);
            bl = true;
        }
        if (!bl) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    @Override
    public void setBLOBAtName(String string, BLOB bLOB) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setBLOB(i2 + 1, bLOB);
            bl = true;
        }
        if (!bl) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    @Override
    public void setCHARAtName(String string, CHAR cHAR) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setCHAR(i2 + 1, cHAR);
            bl = true;
        }
        if (!bl) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    @Override
    public void setCLOBAtName(String string, CLOB cLOB) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setCLOB(i2 + 1, cLOB);
            bl = true;
        }
        if (!bl) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    @Override
    public void setCursorAtName(String string, ResultSet resultSet) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setCursor(i2 + 1, resultSet);
            bl = true;
        }
        if (!bl) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    @Override
    public void setCustomDatumAtName(String string, CustomDatum customDatum) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setCustomDatum(i2 + 1, customDatum);
            bl = true;
        }
        if (!bl) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    @Override
    public void setDATEAtName(String string, DATE dATE) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setDATE(i2 + 1, dATE);
            bl = true;
        }
        if (!bl) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    @Override
    public void setFixedCHARAtName(String string, String string2) throws SQLException {
        String string3 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string3) continue;
            this.setFixedCHAR(i2 + 1, string2);
            bl = true;
        }
        if (!bl) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    @Override
    public void setINTERVALDSAtName(String string, INTERVALDS iNTERVALDS) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setINTERVALDS(i2 + 1, iNTERVALDS);
            bl = true;
        }
        if (!bl) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    @Override
    public void setINTERVALYMAtName(String string, INTERVALYM iNTERVALYM) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setINTERVALYM(i2 + 1, iNTERVALYM);
            bl = true;
        }
        if (!bl) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    @Override
    public void setNUMBERAtName(String string, NUMBER nUMBER) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setNUMBER(i2 + 1, nUMBER);
            bl = true;
        }
        if (!bl) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    @Override
    public void setOPAQUEAtName(String string, OPAQUE oPAQUE) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setOPAQUE(i2 + 1, oPAQUE);
            bl = true;
        }
        if (!bl) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    @Override
    public void setOracleObjectAtName(String string, Datum datum) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setOracleObject(i2 + 1, datum);
            bl = true;
        }
        if (!bl) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    @Override
    public void setORADataAtName(String string, ORAData oRAData) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setORAData(i2 + 1, oRAData);
            bl = true;
        }
        if (!bl) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    @Override
    public void setRAWAtName(String string, RAW rAW) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setRAW(i2 + 1, rAW);
            bl = true;
        }
        if (!bl) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    @Override
    public void setREFAtName(String string, REF rEF) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setREF(i2 + 1, rEF);
            bl = true;
        }
        if (!bl) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    @Override
    public void setRefTypeAtName(String string, REF rEF) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setRefType(i2 + 1, rEF);
            bl = true;
        }
        if (!bl) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    @Override
    public void setROWIDAtName(String string, ROWID rOWID) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setROWID(i2 + 1, rOWID);
            bl = true;
        }
        if (!bl) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    @Override
    public void setSTRUCTAtName(String string, STRUCT sTRUCT) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setSTRUCT(i2 + 1, sTRUCT);
            bl = true;
        }
        if (!bl) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    @Override
    public void setTIMESTAMPLTZAtName(String string, TIMESTAMPLTZ tIMESTAMPLTZ) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setTIMESTAMPLTZ(i2 + 1, tIMESTAMPLTZ);
            bl = true;
        }
        if (!bl) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    @Override
    public void setTIMESTAMPTZAtName(String string, TIMESTAMPTZ tIMESTAMPTZ) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setTIMESTAMPTZ(i2 + 1, tIMESTAMPTZ);
            bl = true;
        }
        if (!bl) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    @Override
    public void setTIMESTAMPAtName(String string, TIMESTAMP tIMESTAMP) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setTIMESTAMP(i2 + 1, tIMESTAMP);
            bl = true;
        }
        if (!bl) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    @Override
    public void setBlobAtName(String string, InputStream inputStream) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        int n2 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        boolean bl = true;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            if (bl) {
                this.setBlob(i2 + 1, inputStream);
                bl = false;
                continue;
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 135);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (bl) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    @Override
    public void setBlobAtName(String string, InputStream inputStream, long l2) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        int n2 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        boolean bl = true;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            if (bl) {
                this.setBlob(i2 + 1, inputStream, l2);
                bl = false;
                continue;
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 135);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (bl) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    @Override
    public void setClobAtName(String string, Reader reader) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        int n2 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        boolean bl = true;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            if (bl) {
                this.setClob(i2 + 1, reader);
                bl = false;
                continue;
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 135);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (bl) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    @Override
    public void setClobAtName(String string, Reader reader, long l2) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        int n2 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        boolean bl = true;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            if (bl) {
                this.setClob(i2 + 1, reader, l2);
                bl = false;
                continue;
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 135);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (bl) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    @Override
    public void setNClobAtName(String string, Reader reader) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        int n2 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        boolean bl = true;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            if (bl) {
                this.setNClob(i2 + 1, reader);
                bl = false;
                continue;
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 135);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (bl) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    @Override
    public void setNClobAtName(String string, Reader reader, long l2) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        int n2 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        boolean bl = true;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            if (bl) {
                this.setNClob(i2 + 1, reader, l2);
                bl = false;
                continue;
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 135);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (bl) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    @Override
    public void setAsciiStreamAtName(String string, InputStream inputStream) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        int n2 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        boolean bl = true;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            if (bl) {
                this.setAsciiStream(i2 + 1, inputStream);
                bl = false;
                continue;
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 135);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (bl) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    @Override
    public void setAsciiStreamAtName(String string, InputStream inputStream, int n2) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        int n3 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        boolean bl = true;
        for (int i2 = 0; i2 < n3; ++i2) {
            if (stringArray[i2] != string2) continue;
            if (bl) {
                this.setAsciiStream(i2 + 1, inputStream, n2);
                bl = false;
                continue;
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 135);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (bl) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    @Override
    public void setAsciiStreamAtName(String string, InputStream inputStream, long l2) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        int n2 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        boolean bl = true;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            if (bl) {
                this.setAsciiStream(i2 + 1, inputStream, l2);
                bl = false;
                continue;
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 135);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (bl) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    @Override
    public void setBinaryStreamAtName(String string, InputStream inputStream) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        int n2 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        boolean bl = true;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            if (bl) {
                this.setBinaryStream(i2 + 1, inputStream);
                bl = false;
                continue;
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 135);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (bl) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    @Override
    public void setBinaryStreamAtName(String string, InputStream inputStream, int n2) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        int n3 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        boolean bl = true;
        for (int i2 = 0; i2 < n3; ++i2) {
            if (stringArray[i2] != string2) continue;
            if (bl) {
                this.setBinaryStream(i2 + 1, inputStream, n2);
                bl = false;
                continue;
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 135);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (bl) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    @Override
    public void setBinaryStreamAtName(String string, InputStream inputStream, long l2) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        int n2 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        boolean bl = true;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            if (bl) {
                this.setBinaryStream(i2 + 1, inputStream, l2);
                bl = false;
                continue;
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 135);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (bl) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    @Override
    public void setCharacterStreamAtName(String string, Reader reader) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        int n2 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        boolean bl = true;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            if (bl) {
                this.setCharacterStream(i2 + 1, reader);
                bl = false;
                continue;
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 135);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (bl) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    @Override
    public void setCharacterStreamAtName(String string, Reader reader, int n2) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        int n3 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        boolean bl = true;
        for (int i2 = 0; i2 < n3; ++i2) {
            if (stringArray[i2] != string2) continue;
            if (bl) {
                this.setCharacterStream(i2 + 1, reader, n2);
                bl = false;
                continue;
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 135);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (bl) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    @Override
    public void setCharacterStreamAtName(String string, Reader reader, long l2) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        int n2 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        boolean bl = true;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            if (bl) {
                this.setCharacterStream(i2 + 1, reader, l2);
                bl = false;
                continue;
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 135);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (bl) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    @Override
    public void setNCharacterStreamAtName(String string, Reader reader) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        int n2 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        boolean bl = true;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            if (bl) {
                this.setNCharacterStream(i2 + 1, reader);
                bl = false;
                continue;
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 135);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (bl) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    @Override
    public void setNCharacterStreamAtName(String string, Reader reader, long l2) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        int n2 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        boolean bl = true;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            if (bl) {
                this.setNCharacterStream(i2 + 1, reader, l2);
                bl = false;
                continue;
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 135);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (bl) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    @Override
    public void setUnicodeStreamAtName(String string, InputStream inputStream, int n2) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        int n3 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        boolean bl = true;
        for (int i2 = 0; i2 < n3; ++i2) {
            if (stringArray[i2] != string2) continue;
            if (bl) {
                this.setUnicodeStream(i2 + 1, inputStream, n2);
                bl = false;
                continue;
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 135);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (bl) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    class PushedBatch {
        int[] currentBatchCharLens;
        int[] lastBoundCharLens;
        Accessor[] currentBatchBindAccessors;
        boolean lastBoundNeeded;
        boolean need_to_parse;
        boolean current_batch_need_to_prepare_binds;
        int first_row_in_batch;
        int number_of_rows_to_be_bound;
        PushedBatch next;

        PushedBatch() {
        }
    }
}

