/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CTTIfun;
import oracle.jdbc.internal.OracleConnection;

final class T4CTTIOtxse
extends T4CTTIfun {
    static final int OTXSTA = 1;
    static final int OTXDET = 2;
    static final int OCI_TRANS_NEW = 1;
    static final int OCI_TRANS_JOIN = 2;
    static final int OCI_TRANS_RESUME = 4;
    static final int OCI_TRANS_STARTMASK = 255;
    static final int OCI_TRANS_READONLY = 256;
    static final int OCI_TRANS_READWRITE = 512;
    static final int OCI_TRANS_SERIALIZABLE = 1024;
    static final int OCI_TRANS_ISOLMASK = 65280;
    static final int OCI_TRANS_LOOSE = 65536;
    static final int OCI_TRANS_TIGHT = 131072;
    static final int OCI_TRANS_TYPEMASK = 983040;
    static final int OCI_TRANS_NOMIGRATE = 0x100000;
    static final int OCI_TRANS_SEPARABLE = 0x200000;
    boolean sendTransactionContext = false;
    private int operation;
    private int formatId;
    private int gtridLength;
    private int bqualLength;
    private int timeout;
    private int flag;
    private int[] xidapp = null;
    private byte[] transactionContext;
    private byte[] xid = null;
    private int applicationValue = -1;
    private byte[] ctx = null;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Mon_Aug_29_23:34:29_PDT_2011";
    public static final boolean TRACE = false;

    T4CTTIOtxse(T4CConnection t4CConnection) {
        super(t4CConnection, (byte)3);
        this.setFunCode((short)103);
    }

    void doOTXSE(int n2, byte[] byArray, byte[] byArray2, int n3, int n4, int n5, int n6, int n7, int[] nArray) throws IOException, SQLException {
        if (n2 != 1 && n2 != 2) {
            throw new SQLException("Invalid operation.");
        }
        this.operation = n2;
        this.formatId = n3;
        this.gtridLength = n4;
        this.bqualLength = n5;
        this.timeout = n6;
        this.flag = n7;
        this.xidapp = nArray;
        this.transactionContext = byArray;
        this.xid = byArray2;
        this.applicationValue = -1;
        this.ctx = null;
        if (this.operation == 2 && this.transactionContext == null) {
            throw new SQLException("Transaction context cannot be null when detach is called.");
        }
        this.doRPC();
    }

    @Override
    void marshal() throws IOException {
        int n2 = this.operation;
        this.meg.marshalSWORD(n2);
        if (this.operation == 2) {
            this.sendTransactionContext = true;
            this.meg.marshalPTR();
        } else {
            this.sendTransactionContext = false;
            this.meg.marshalNULLPTR();
        }
        if (this.transactionContext == null) {
            this.meg.marshalUB4(0L);
        } else {
            this.meg.marshalUB4(this.transactionContext.length);
        }
        this.meg.marshalUB4(this.formatId);
        this.meg.marshalUB4(this.gtridLength);
        this.meg.marshalUB4(this.bqualLength);
        if (this.xid != null) {
            this.meg.marshalPTR();
        } else {
            this.meg.marshalNULLPTR();
        }
        if (this.xid != null) {
            this.meg.marshalUB4(this.xid.length);
        } else {
            this.meg.marshalUB4(0L);
        }
        this.meg.marshalUB4(this.flag);
        this.meg.marshalUWORD(this.timeout);
        if (this.xidapp != null) {
            this.meg.marshalPTR();
        } else {
            this.meg.marshalNULLPTR();
        }
        this.meg.marshalPTR();
        this.meg.marshalPTR();
        boolean bl = false;
        boolean bl2 = false;
        if (this.connection.getTTCVersion() >= 5) {
            if (this.connection.internalName != null) {
                bl = true;
                this.meg.marshalPTR();
                this.meg.marshalUB4(this.connection.internalName.length);
            } else {
                this.meg.marshalNULLPTR();
                this.meg.marshalUB4(0L);
            }
            if (this.connection.externalName != null) {
                bl2 = true;
                this.meg.marshalPTR();
                this.meg.marshalUB4(this.connection.externalName.length);
            } else {
                this.meg.marshalNULLPTR();
                this.meg.marshalUB4(0L);
            }
        }
        if (this.sendTransactionContext) {
            this.meg.marshalB1Array(this.transactionContext);
        }
        if (this.xid != null) {
            this.meg.marshalB1Array(this.xid);
        }
        if (this.xidapp != null) {
            this.meg.marshalUB4(this.xidapp[0]);
        }
        if (this.connection.getTTCVersion() >= 5) {
            if (bl) {
                this.meg.marshalCHR(this.connection.internalName);
            }
            if (bl2) {
                this.meg.marshalCHR(this.connection.externalName);
            }
        }
    }

    byte[] getContext() {
        return this.ctx;
    }

    int getApplicationValue() {
        return this.applicationValue;
    }

    @Override
    void readRPA() throws IOException, SQLException {
        this.applicationValue = (int)this.meg.unmarshalUB4();
        int n2 = this.meg.unmarshalUB2();
        this.ctx = this.meg.unmarshalNBytes(n2);
    }

    @Override
    protected OracleConnection getConnectionDuringExceptionHandling() {
        return this.connection;
    }
}

