/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.pool;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Wrapper;
import java.util.Enumeration;
import java.util.Properties;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.DataSource;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleDriver;
import oracle.jdbc.pool.OracleConnectionCacheManager;
import oracle.jdbc.pool.OracleImplicitConnectionCache;

public class OracleDataSource
implements DataSource,
Serializable,
Referenceable {
    static final long serialVersionUID = 3349652938965166731L;
    protected PrintWriter logWriter = null;
    protected int loginTimeout = 0;
    protected String databaseName = null;
    protected String serviceName = null;
    protected String dataSourceName = "OracleDataSource";
    protected String description = null;
    protected String networkProtocol = "tcp";
    protected int portNumber = 0;
    protected String user = null;
    protected String password = null;
    protected String serverName = null;
    protected String url = null;
    protected String driverType = null;
    protected String tnsEntry = null;
    protected int maxStatements = 0;
    protected boolean implicitCachingEnabled = false;
    protected boolean explicitCachingEnabled = false;
    protected transient OracleImplicitConnectionCache odsCache = null;
    protected transient OracleConnectionCacheManager cacheManager = null;
    protected String connCacheName = null;
    protected Properties connCacheProperties = null;
    protected Properties connectionProperties = null;
    protected boolean connCachingEnabled = false;
    protected boolean fastConnFailover = false;
    protected String onsConfigStr = null;
    public boolean isOracleDataSource = true;
    private static final boolean fastConnectionFailoverSysProperty = "true".equalsIgnoreCase(OracleDriver.getSystemPropertyFastConnectionFailover("false"));
    private boolean urlExplicit = false;
    private boolean useDefaultConnection = false;
    protected transient OracleDriver driver = new OracleDriver();
    private static final String spawnNewThreadToCancelProperty = "oracle.jdbc.spawnNewThreadToCancel";
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Mon_Aug_29_23:34:29_PDT_2011";
    public static final boolean TRACE = false;

    public OracleDataSource() throws SQLException {
        this.processFastConnectionFailoverSysProperty();
    }

    void processFastConnectionFailoverSysProperty() {
        if (this.isOracleDataSource && fastConnectionFailoverSysProperty) {
            this.connCachingEnabled = true;
            if (this.cacheManager == null) {
                try {
                    this.cacheManager = OracleConnectionCacheManager.getConnectionCacheManagerInstance();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            this.fastConnFailover = true;
            this.setSpawnNewThreadToCancel(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection getConnection() throws SQLException {
        String string = null;
        String string2 = null;
        OracleDataSource oracleDataSource = this;
        synchronized (oracleDataSource) {
            string = this.user;
            string2 = this.password;
        }
        return this.getConnection(string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection getConnection(String string, String string2) throws SQLException {
        Connection connection = null;
        Properties properties = null;
        if (this.connCachingEnabled) {
            connection = this.getConnection(string, string2, null);
        } else {
            Serializable serializable = this;
            synchronized (serializable) {
                this.makeURL();
                Properties properties2 = properties = this.connectionProperties == null ? new Properties() : (Properties)this.connectionProperties.clone();
                if (this.url != null) {
                    properties.setProperty("connection_url", this.url);
                }
                if (string != null) {
                    properties.setProperty("user", string);
                }
                if (string2 != null) {
                    properties.setProperty("password", string2);
                }
                if (this.loginTimeout != 0) {
                    properties.setProperty("LoginTimeout", "" + this.loginTimeout);
                }
                if (this.maxStatements != 0) {
                    properties.setProperty("stmt_cache_size", "" + this.maxStatements);
                }
            }
            connection = this.getPhysicalConnection(properties);
            if (connection == null) {
                serializable = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 67);
                ((Throwable)serializable).fillInStackTrace();
                throw serializable;
            }
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Connection getPhysicalConnection(Properties properties) throws SQLException {
        Connection connection = null;
        Properties properties2 = properties;
        String string = properties.getProperty("connection_url");
        String string2 = properties.getProperty("user");
        String string3 = properties2.getProperty("password");
        String string4 = null;
        boolean bl = false;
        Serializable serializable = this;
        synchronized (serializable) {
            String string5;
            if (this.connectionProperties != null) {
                properties2 = (Properties)this.connectionProperties.clone();
                if (string2 != null) {
                    properties2.put("user", string2);
                }
                if (string3 != null) {
                    properties2.put("password", string3);
                }
            }
            if (string2 == null && this.user != null) {
                properties2.put("user", this.user);
            }
            if (string3 == null && this.password != null) {
                properties2.put("password", this.password);
            }
            if (string == null) {
                string = this.url;
            }
            if ((string5 = properties.getProperty("LoginTimeout")) != null) {
                properties2.put("oracle.net.CONNECT_TIMEOUT", "" + Integer.parseInt(string5) * 1000);
            }
            bl = this.useDefaultConnection;
            if (this.driver == null) {
                this.driver = new OracleDriver();
            }
        }
        connection = bl ? this.driver.defaultConnection() : this.driver.connect(string, properties2);
        if (connection == null) {
            serializable = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 67);
            ((Throwable)serializable).fillInStackTrace();
            throw serializable;
        }
        string4 = properties.getProperty("stmt_cache_size");
        int n2 = 0;
        if (string4 != null) {
            n2 = Integer.parseInt(string4);
            ((OracleConnection)connection).setStatementCacheSize(n2);
        }
        boolean bl2 = false;
        string4 = properties.getProperty("ExplicitStatementCachingEnabled");
        if (string4 != null) {
            bl2 = string4.equals("true");
            ((OracleConnection)connection).setExplicitCachingEnabled(bl2);
        }
        boolean bl3 = false;
        string4 = properties.getProperty("ImplicitStatementCachingEnabled");
        if (string4 != null) {
            bl3 = string4.equals("true");
            ((OracleConnection)connection).setImplicitCachingEnabled(bl3);
        }
        if (n2 > 0 && !bl2 && !bl3) {
            ((OracleConnection)connection).setImplicitCachingEnabled(true);
            ((OracleConnection)connection).setExplicitCachingEnabled(true);
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection(Properties properties) throws SQLException {
        String string = null;
        String string2 = null;
        Wrapper wrapper = this;
        synchronized (wrapper) {
            if (!this.connCachingEnabled) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 137);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            string = this.user;
            string2 = this.password;
        }
        wrapper = this.getConnection(string, string2, properties);
        return wrapper;
    }

    public Connection getConnection(String string, String string2, Properties properties) throws SQLException {
        if (!this.connCachingEnabled) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 137);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.odsCache == null) {
            this.cacheInitialize();
        }
        Connection connection = this.odsCache.getConnection(string, string2, properties);
        return connection;
    }

    private synchronized void cacheInitialize() throws SQLException {
        if (this.odsCache == null) {
            if (this.connCacheName != null) {
                this.cacheManager.createCache(this.connCacheName, this, this.connCacheProperties);
            } else {
                this.connCacheName = this.cacheManager.createCache(this, this.connCacheProperties);
            }
        }
    }

    public synchronized void close() throws SQLException {
        if (this.connCachingEnabled && this.odsCache != null) {
            this.cacheManager.removeCache(this.odsCache.cacheName, 0L);
            this.odsCache = null;
        }
    }

    public synchronized void setConnectionCachingEnabled(boolean bl) throws SQLException {
        if (this.isOracleDataSource) {
            if (bl) {
                this.connCachingEnabled = true;
                if (this.cacheManager == null) {
                    this.cacheManager = OracleConnectionCacheManager.getConnectionCacheManagerInstance();
                }
            } else if (this.odsCache == null) {
                this.connCachingEnabled = false;
                this.fastConnFailover = false;
                this.setSpawnNewThreadToCancel(false);
                this.connCacheName = null;
                this.connCacheProperties = null;
            }
        } else {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 137);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    public boolean getConnectionCachingEnabled() throws SQLException {
        return this.connCachingEnabled;
    }

    public synchronized void setConnectionCacheName(String string) throws SQLException {
        if (string == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 138);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.connCacheName = string;
    }

    public String getConnectionCacheName() throws SQLException {
        if (this.connCachingEnabled && this.odsCache != null) {
            return this.odsCache.cacheName;
        }
        return this.connCacheName;
    }

    public synchronized void setConnectionCacheProperties(Properties properties) throws SQLException {
        this.connCacheProperties = properties;
    }

    public Properties getConnectionCacheProperties() throws SQLException {
        if (this.connCachingEnabled && this.odsCache != null) {
            return this.odsCache.getConnectionCacheProperties();
        }
        return this.connCacheProperties;
    }

    public synchronized void setFastConnectionFailoverEnabled(boolean bl) throws SQLException {
        if (!this.fastConnFailover) {
            this.fastConnFailover = bl;
            this.setSpawnNewThreadToCancel(bl);
        } else if (!bl) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 255);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    public boolean getFastConnectionFailoverEnabled() throws SQLException {
        return this.fastConnFailover;
    }

    public String getONSConfiguration() throws SQLException {
        return this.onsConfigStr;
    }

    public synchronized void setONSConfiguration(String string) throws SQLException {
        this.onsConfigStr = string;
    }

    @Override
    public synchronized int getLoginTimeout() {
        return this.loginTimeout;
    }

    @Override
    public synchronized void setLoginTimeout(int n2) {
        this.loginTimeout = n2;
    }

    @Override
    public synchronized void setLogWriter(PrintWriter printWriter) {
        this.logWriter = printWriter;
    }

    @Override
    public synchronized PrintWriter getLogWriter() {
        return this.logWriter;
    }

    public synchronized void setTNSEntryName(String string) {
        this.tnsEntry = string;
    }

    public synchronized String getTNSEntryName() {
        return this.tnsEntry;
    }

    public synchronized void setDataSourceName(String string) {
        this.dataSourceName = string;
    }

    public synchronized String getDataSourceName() {
        return this.dataSourceName;
    }

    public synchronized String getDatabaseName() {
        return this.databaseName;
    }

    public synchronized void setDatabaseName(String string) {
        this.databaseName = string;
    }

    public synchronized void setServiceName(String string) {
        this.serviceName = string;
    }

    public synchronized String getServiceName() {
        return this.serviceName;
    }

    public synchronized void setServerName(String string) {
        this.serverName = string;
    }

    public synchronized String getServerName() {
        return this.serverName;
    }

    public synchronized void setURL(String string) {
        this.url = string;
        if (this.url != null) {
            this.urlExplicit = true;
        }
        if (this.connCachingEnabled && this.odsCache != null && this.odsCache.connectionPoolDS != null) {
            this.odsCache.connectionPoolDS.url = string;
        }
    }

    public synchronized String getURL() throws SQLException {
        if (!this.urlExplicit) {
            this.makeURL();
        }
        return this.url;
    }

    public synchronized void setUser(String string) {
        this.user = string;
    }

    public String getUser() {
        return this.user;
    }

    public synchronized void setPassword(String string) {
        this.password = string;
    }

    protected String getPassword() {
        return this.password;
    }

    public synchronized String getDescription() {
        return this.description;
    }

    public synchronized void setDescription(String string) {
        this.description = string;
    }

    public synchronized String getDriverType() {
        return this.driverType;
    }

    public synchronized void setDriverType(String string) {
        this.driverType = string;
    }

    public synchronized String getNetworkProtocol() {
        return this.networkProtocol;
    }

    public synchronized void setNetworkProtocol(String string) {
        this.networkProtocol = string;
    }

    public synchronized void setPortNumber(int n2) {
        this.portNumber = n2;
    }

    public synchronized int getPortNumber() {
        return this.portNumber;
    }

    @Override
    public synchronized Reference getReference() throws NamingException {
        Reference reference = new Reference(this.getClass().getName(), "oracle.jdbc.pool.OracleDataSourceFactory", null);
        this.addRefProperties(reference);
        return reference;
    }

    protected void addRefProperties(Reference reference) {
        if (this.url != null) {
            reference.add(new StringRefAddr("url", this.url));
        }
        if (this.user != null) {
            reference.add(new StringRefAddr("userName", this.user));
        }
        if (this.password != null) {
            reference.add(new StringRefAddr("passWord", this.password));
        }
        if (this.description != null) {
            reference.add(new StringRefAddr("description", this.description));
        }
        if (this.driverType != null) {
            reference.add(new StringRefAddr("driverType", this.driverType));
        }
        if (this.serverName != null) {
            reference.add(new StringRefAddr("serverName", this.serverName));
        }
        if (this.databaseName != null) {
            reference.add(new StringRefAddr("databaseName", this.databaseName));
        }
        if (this.serviceName != null) {
            reference.add(new StringRefAddr("serviceName", this.serviceName));
        }
        if (this.networkProtocol != null) {
            reference.add(new StringRefAddr("networkProtocol", this.networkProtocol));
        }
        if (this.portNumber != 0) {
            reference.add(new StringRefAddr("portNumber", Integer.toString(this.portNumber)));
        }
        if (this.tnsEntry != null) {
            reference.add(new StringRefAddr("tnsentryname", this.tnsEntry));
        }
        if (this.maxStatements != 0) {
            reference.add(new StringRefAddr("maxStatements", Integer.toString(this.maxStatements)));
        }
        if (this.implicitCachingEnabled) {
            reference.add(new StringRefAddr("implicitCachingEnabled", "true"));
        }
        if (this.explicitCachingEnabled) {
            reference.add(new StringRefAddr("explicitCachingEnabled", "true"));
        }
        if (this.connCachingEnabled) {
            reference.add(new StringRefAddr("connectionCachingEnabled", "true"));
        }
        if (this.connCacheName != null) {
            reference.add(new StringRefAddr("connectionCacheName", this.connCacheName));
        }
        if (this.connCacheProperties != null) {
            reference.add(new StringRefAddr("connectionCacheProperties", this.connCacheProperties.toString()));
        }
        if (this.fastConnFailover) {
            reference.add(new StringRefAddr("fastConnectionFailoverEnabled", "true"));
        }
        if (this.onsConfigStr != null) {
            reference.add(new StringRefAddr("onsConfigStr", this.onsConfigStr));
        }
    }

    void makeURL() throws SQLException {
        if (this.urlExplicit) {
            return;
        }
        if (this.driverType == null || !this.driverType.equals("oci8") && !this.driverType.equals("oci") && !this.driverType.equals("thin") && !this.driverType.equals("kprb")) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 67, "OracleDataSource.makeURL");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.driverType.equals("kprb")) {
            this.useDefaultConnection = true;
            this.url = "jdbc:oracle:kprb:@";
            return;
        }
        if ((this.driverType.equals("oci8") || this.driverType.equals("oci")) && this.networkProtocol != null && this.networkProtocol.equals("ipc")) {
            this.url = "jdbc:oracle:oci:@";
            return;
        }
        if (this.tnsEntry != null) {
            this.url = "jdbc:oracle:" + this.driverType + ":@" + this.tnsEntry;
            return;
        }
        if (this.serviceName != null) {
            this.url = "jdbc:oracle:" + this.driverType + ":@(DESCRIPTION=(ADDRESS=(PROTOCOL=" + this.networkProtocol + ")(PORT=" + this.portNumber + ")(HOST=" + this.serverName + "))(CONNECT_DATA=(SERVICE_NAME=" + this.serviceName + ")))";
        } else {
            this.url = "jdbc:oracle:" + this.driverType + ":@(DESCRIPTION=(ADDRESS=(PROTOCOL=" + this.networkProtocol + ")(PORT=" + this.portNumber + ")(HOST=" + this.serverName + "))(CONNECT_DATA=(SID=" + this.databaseName + ")))";
            DatabaseError.addSqlWarning(null, new SQLWarning("URL with SID jdbc:subprotocol:@host:port:sid will be deprecated in 10i\nPlease use URL with SERVICE_NAME as jdbc:subprotocol:@//host:port/service_name"));
            if (this.fastConnFailover) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 67, "OracleDataSource.makeURL");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        }
    }

    protected void trace(String string) {
        if (this.logWriter != null) {
            // empty if block
        }
    }

    protected void copy(OracleDataSource oracleDataSource) throws SQLException {
        oracleDataSource.setUser(this.user);
        oracleDataSource.setPassword(this.password);
        oracleDataSource.setTNSEntryName(this.tnsEntry);
        this.makeURL();
        oracleDataSource.setURL(this.url);
        if (this.loginTimeout > 0) {
            oracleDataSource.setLoginTimeout(this.loginTimeout);
        }
        oracleDataSource.connectionProperties = this.connectionProperties;
    }

    public void setMaxStatements(int n2) throws SQLException {
        this.maxStatements = n2;
    }

    public int getMaxStatements() throws SQLException {
        return this.maxStatements;
    }

    public void setImplicitCachingEnabled(boolean bl) throws SQLException {
        this.implicitCachingEnabled = bl;
    }

    public boolean getImplicitCachingEnabled() throws SQLException {
        return this.implicitCachingEnabled;
    }

    public void setExplicitCachingEnabled(boolean bl) throws SQLException {
        this.explicitCachingEnabled = bl;
    }

    public boolean getExplicitCachingEnabled() throws SQLException {
        return this.explicitCachingEnabled;
    }

    public void setConnectionProperties(Properties properties) throws SQLException {
        this.connectionProperties = properties == null ? properties : (Properties)properties.clone();
        this.setSpawnNewThreadToCancel(this.fastConnFailover);
    }

    public Properties getConnectionProperties() throws SQLException {
        return OracleDataSource.filterConnectionProperties(this.connectionProperties);
    }

    public static final Properties filterConnectionProperties(Properties properties) {
        Properties properties2 = null;
        if (properties != null) {
            properties2 = (Properties)properties.clone();
            Enumeration<?> enumeration = properties2.propertyNames();
            Object var3_3 = null;
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (string == null || !string.matches(".*[P,p][A,a][S,s][S,s][W,w][O,o][R,r][D,d].*")) continue;
                properties2.remove(string);
            }
            properties.remove(spawnNewThreadToCancelProperty);
        }
        return properties2;
    }

    private void setSpawnNewThreadToCancel(boolean bl) {
        if (bl) {
            if (this.connectionProperties == null) {
                this.connectionProperties = new Properties();
            }
            this.connectionProperties.setProperty(spawnNewThreadToCancelProperty, "true");
        } else if (this.connectionProperties != null) {
            this.connectionProperties.remove(spawnNewThreadToCancelProperty);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException, SQLException {
        objectInputStream.defaultReadObject();
        if (this.connCachingEnabled) {
            this.setConnectionCachingEnabled(this.connCachingEnabled);
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        if (clazz.isInterface()) {
            return clazz.isInstance(this);
        }
        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 177);
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        if (clazz.isInterface() && clazz.isInstance(this)) {
            return (T)this;
        }
        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 177);
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    protected oracle.jdbc.internal.OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }
}

